/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.Skills;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

public class UpdateSkills
implements StateUpdater,
ActivityVisitor {
    private Skills.Builder skillBuilder;
    private StateManager statesManager;
    private VehicleRoute route;

    public UpdateSkills(StateManager statesManager) {
        this.statesManager = statesManager;
    }

    @Override
    public void begin(VehicleRoute route) {
        this.route = route;
        this.skillBuilder = Skills.Builder.newInstance();
    }

    @Override
    public void visit(TourActivity activity) {
        if (activity instanceof TourActivity.JobActivity) {
            Skills skills = ((TourActivity.JobActivity)activity).getJob().getRequiredSkills();
            this.skillBuilder.addAllSkills(skills.values());
        }
    }

    @Override
    public void finish() {
        Skills skills = this.skillBuilder.build();
        this.statesManager.putTypedInternalRouteState(this.route, InternalStates.SKILLS, skills);
    }
}

