/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.constraint;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.job.Pickup;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;

public class ServiceLoadRouteLevelConstraint
implements HardRouteConstraint {
    private RouteAndActivityStateGetter stateManager;
    private Capacity defaultValue;

    public ServiceLoadRouteLevelConstraint(RouteAndActivityStateGetter stateManager) {
        this.stateManager = stateManager;
        this.defaultValue = Capacity.Builder.newInstance().build();
    }

    @Override
    public boolean fulfilled(JobInsertionContext insertionContext) {
        Capacity capacityDimensions;
        Capacity maxLoadAtRoute = this.stateManager.getRouteState(insertionContext.getRoute(), InternalStates.MAXLOAD, Capacity.class);
        if (maxLoadAtRoute == null) {
            maxLoadAtRoute = this.defaultValue;
        }
        if (!maxLoadAtRoute.isLessOrEqual(capacityDimensions = insertionContext.getNewVehicle().getType().getCapacityDimensions())) {
            return false;
        }
        if (insertionContext.getJob() instanceof Delivery) {
            Capacity loadAtDepot = this.stateManager.getRouteState(insertionContext.getRoute(), InternalStates.LOAD_AT_BEGINNING, Capacity.class);
            if (loadAtDepot == null) {
                loadAtDepot = this.defaultValue;
            }
            if (!Capacity.addup(loadAtDepot, insertionContext.getJob().getSize()).isLessOrEqual(capacityDimensions)) {
                return false;
            }
        } else if (insertionContext.getJob() instanceof Pickup || insertionContext.getJob() instanceof Service) {
            Capacity loadAtEnd = this.stateManager.getRouteState(insertionContext.getRoute(), InternalStates.LOAD_AT_END, Capacity.class);
            if (loadAtEnd == null) {
                loadAtEnd = this.defaultValue;
            }
            if (!Capacity.addup(loadAtEnd, insertionContext.getJob().getSize()).isLessOrEqual(capacityDimensions)) {
                return false;
            }
        }
        return true;
    }
}

