/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.job;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.Skills;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindowsImpl;
import java.util.Collection;

public class Shipment
extends AbstractJob {
    private final String id;
    private final double pickupServiceTime;
    private final double deliveryServiceTime;
    private final TimeWindow deliveryTimeWindow;
    private final TimeWindow pickupTimeWindow;
    private final Capacity capacity;
    private final Skills skills;
    private final String name;
    private final Location pickupLocation_;
    private final Location deliveryLocation_;
    private final TimeWindowsImpl deliveryTimeWindows;
    private final TimeWindowsImpl pickupTimeWindows;
    private final int priority;

    Shipment(Builder builder) {
        this.id = builder.id;
        this.pickupServiceTime = builder.pickupServiceTime;
        this.pickupTimeWindow = builder.pickupTimeWindow;
        this.deliveryServiceTime = builder.deliveryServiceTime;
        this.deliveryTimeWindow = builder.deliveryTimeWindow;
        this.capacity = builder.capacity;
        this.skills = builder.skills;
        this.name = builder.name;
        this.pickupLocation_ = builder.pickupLocation_;
        this.deliveryLocation_ = builder.deliveryLocation_;
        this.deliveryTimeWindows = builder.deliveryTimeWindows;
        this.pickupTimeWindows = builder.pickupTimeWindows;
        this.priority = builder.priority;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Location getPickupLocation() {
        return this.pickupLocation_;
    }

    public double getPickupServiceTime() {
        return this.pickupServiceTime;
    }

    public Location getDeliveryLocation() {
        return this.deliveryLocation_;
    }

    public double getDeliveryServiceTime() {
        return this.deliveryServiceTime;
    }

    public TimeWindow getDeliveryTimeWindow() {
        return this.deliveryTimeWindows.getTimeWindows().iterator().next();
    }

    public Collection<TimeWindow> getDeliveryTimeWindows() {
        return this.deliveryTimeWindows.getTimeWindows();
    }

    public TimeWindow getPickupTimeWindow() {
        return this.pickupTimeWindows.getTimeWindows().iterator().next();
    }

    public Collection<TimeWindow> getPickupTimeWindows() {
        return this.pickupTimeWindows.getTimeWindows();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Shipment other = (Shipment)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public Capacity getSize() {
        return this.capacity;
    }

    @Override
    public Skills getRequiredSkills() {
        return this.skills;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public static class Builder {
        private String id;
        private double pickupServiceTime = 0.0;
        private double deliveryServiceTime = 0.0;
        private TimeWindow deliveryTimeWindow = TimeWindow.newInstance(0.0, Double.MAX_VALUE);
        private TimeWindow pickupTimeWindow = TimeWindow.newInstance(0.0, Double.MAX_VALUE);
        private Capacity.Builder capacityBuilder = Capacity.Builder.newInstance();
        private Capacity capacity;
        private Skills.Builder skillBuilder = Skills.Builder.newInstance();
        private Skills skills;
        private String name = "no-name";
        private Location pickupLocation_;
        private Location deliveryLocation_;
        protected TimeWindowsImpl deliveryTimeWindows;
        private boolean deliveryTimeWindowAdded = false;
        private boolean pickupTimeWindowAdded = false;
        private TimeWindowsImpl pickupTimeWindows;
        private int priority = 2;

        public static Builder newInstance(String id) {
            return new Builder(id);
        }

        Builder(String id) {
            if (id == null) {
                throw new IllegalArgumentException("id must not be null");
            }
            this.id = id;
            this.pickupTimeWindows = new TimeWindowsImpl();
            this.pickupTimeWindows.add(this.pickupTimeWindow);
            this.deliveryTimeWindows = new TimeWindowsImpl();
            this.deliveryTimeWindows.add(this.deliveryTimeWindow);
        }

        public Builder setPickupLocation(Location pickupLocation) {
            this.pickupLocation_ = pickupLocation;
            return this;
        }

        public Builder setPickupServiceTime(double serviceTime) {
            if (serviceTime < 0.0) {
                throw new IllegalArgumentException("serviceTime must not be < 0.0");
            }
            this.pickupServiceTime = serviceTime;
            return this;
        }

        public Builder setPickupTimeWindow(TimeWindow timeWindow) {
            if (timeWindow == null) {
                throw new IllegalArgumentException("delivery time-window must not be null");
            }
            this.pickupTimeWindow = timeWindow;
            this.pickupTimeWindows = new TimeWindowsImpl();
            this.pickupTimeWindows.add(timeWindow);
            return this;
        }

        public Builder setDeliveryLocation(Location deliveryLocation) {
            this.deliveryLocation_ = deliveryLocation;
            return this;
        }

        public Builder setDeliveryServiceTime(double deliveryServiceTime) {
            if (deliveryServiceTime < 0.0) {
                throw new IllegalArgumentException("deliveryServiceTime must not be < 0.0");
            }
            this.deliveryServiceTime = deliveryServiceTime;
            return this;
        }

        public Builder setDeliveryTimeWindow(TimeWindow timeWindow) {
            if (timeWindow == null) {
                throw new IllegalArgumentException("delivery time-window must not be null");
            }
            this.deliveryTimeWindow = timeWindow;
            this.deliveryTimeWindows = new TimeWindowsImpl();
            this.deliveryTimeWindows.add(timeWindow);
            return this;
        }

        public Builder addSizeDimension(int dimensionIndex, int dimensionValue) {
            if (dimensionValue < 0) {
                throw new IllegalArgumentException("capacity value cannot be negative");
            }
            this.capacityBuilder.addDimension(dimensionIndex, dimensionValue);
            return this;
        }

        public Shipment build() {
            if (this.pickupLocation_ == null) {
                throw new IllegalArgumentException("pickup location is missing");
            }
            if (this.deliveryLocation_ == null) {
                throw new IllegalArgumentException("delivery location is missing");
            }
            this.capacity = this.capacityBuilder.build();
            this.skills = this.skillBuilder.build();
            return new Shipment(this);
        }

        public Builder addRequiredSkill(String skill) {
            this.skillBuilder.addSkill(skill);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addDeliveryTimeWindow(TimeWindow timeWindow) {
            if (timeWindow == null) {
                throw new IllegalArgumentException("time-window arg must not be null");
            }
            if (!this.deliveryTimeWindowAdded) {
                this.deliveryTimeWindows = new TimeWindowsImpl();
                this.deliveryTimeWindowAdded = true;
            }
            this.deliveryTimeWindows.add(timeWindow);
            return this;
        }

        public Builder addDeliveryTimeWindow(double earliest, double latest) {
            this.addDeliveryTimeWindow(TimeWindow.newInstance(earliest, latest));
            return this;
        }

        public Builder addPickupTimeWindow(TimeWindow timeWindow) {
            if (timeWindow == null) {
                throw new IllegalArgumentException("time-window arg must not be null");
            }
            if (!this.pickupTimeWindowAdded) {
                this.pickupTimeWindows = new TimeWindowsImpl();
                this.pickupTimeWindowAdded = true;
            }
            this.pickupTimeWindows.add(timeWindow);
            return this;
        }

        public Builder addPickupTimeWindow(double earliest, double latest) {
            return this.addPickupTimeWindow(TimeWindow.newInstance(earliest, latest));
        }

        public Builder setPriority(int priority) {
            if (priority < 1 || priority > 3) {
                throw new IllegalArgumentException("incorrect priority. only 1 = high, 2 = medium and 3 = low is allowed");
            }
            this.priority = priority;
            return this;
        }
    }
}

