/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route.activity;

import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Activities;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

public final class End
extends AbstractActivity
implements TourActivity {
    private static final Capacity capacity = Capacity.Builder.newInstance().build();
    private double endTime = -1.0;
    private double theoretical_earliestOperationStartTime;
    private double theoretical_latestOperationStartTime;
    private double arrTime;
    private Location location;

    public static End newInstance(String locationId, double earliestArrival, double latestArrival) {
        return new End(locationId, earliestArrival, latestArrival);
    }

    public static End copyOf(End end) {
        return new End(end);
    }

    @Override
    public void setTheoreticalEarliestOperationStartTime(double theoreticalEarliestOperationStartTime) {
        this.theoretical_earliestOperationStartTime = theoreticalEarliestOperationStartTime;
    }

    @Override
    public void setTheoreticalLatestOperationStartTime(double theoreticalLatestOperationStartTime) {
        this.theoretical_latestOperationStartTime = theoreticalLatestOperationStartTime;
    }

    public End(Location location, double theoreticalStart, double theoreticalEnd) {
        this.location = location;
        this.theoretical_earliestOperationStartTime = theoreticalStart;
        this.theoretical_latestOperationStartTime = theoreticalEnd;
        this.endTime = theoreticalEnd;
        this.setIndex(-2);
    }

    public End(String locationId, double theoreticalStart, double theoreticalEnd) {
        if (locationId != null) {
            this.location = Location.Builder.newInstance().setId(locationId).build();
        }
        this.theoretical_earliestOperationStartTime = theoreticalStart;
        this.theoretical_latestOperationStartTime = theoreticalEnd;
        this.endTime = theoreticalEnd;
        this.setIndex(-2);
    }

    public End(End end) {
        this.location = end.getLocation();
        this.theoretical_earliestOperationStartTime = end.getTheoreticalEarliestOperationStartTime();
        this.theoretical_latestOperationStartTime = end.getTheoreticalLatestOperationStartTime();
        this.arrTime = end.getArrTime();
        this.endTime = end.getEndTime();
        this.setIndex(-2);
    }

    @Override
    public double getTheoreticalEarliestOperationStartTime() {
        return this.theoretical_earliestOperationStartTime;
    }

    @Override
    public double getTheoreticalLatestOperationStartTime() {
        return this.theoretical_latestOperationStartTime;
    }

    @Override
    public double getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public double getOperationTime() {
        return 0.0;
    }

    public String toString() {
        return "[type=" + this.getName() + "][location=" + this.location + "][twStart=" + Activities.round(this.theoretical_earliestOperationStartTime) + "][twEnd=" + Activities.round(this.theoretical_latestOperationStartTime) + "]";
    }

    @Override
    public String getName() {
        return "end";
    }

    @Override
    public double getArrTime() {
        return this.arrTime;
    }

    @Override
    public void setArrTime(double arrTime) {
        this.arrTime = arrTime;
    }

    @Override
    public TourActivity duplicate() {
        return new End(this);
    }

    @Override
    public Capacity getSize() {
        return capacity;
    }
}

