/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route.activity;

import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.job.Pickup;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Activities;
import com.graphhopper.jsprit.core.problem.solution.route.activity.PickupActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

public final class PickupService
extends AbstractActivity
implements PickupActivity {
    private Service pickup;
    private double arrTime;
    private double depTime;
    private double theoreticalEarliest = 0.0;
    private double theoreticalLatest = Double.MAX_VALUE;

    public PickupService(Pickup pickup) {
        this.pickup = pickup;
    }

    public PickupService(Service service) {
        this.pickup = service;
    }

    private PickupService(PickupService pickupActivity) {
        this.pickup = pickupActivity.getJob();
        this.arrTime = pickupActivity.getArrTime();
        this.depTime = pickupActivity.getEndTime();
        this.setIndex(pickupActivity.getIndex());
        this.theoreticalEarliest = pickupActivity.getTheoreticalEarliestOperationStartTime();
        this.theoreticalLatest = pickupActivity.getTheoreticalLatestOperationStartTime();
    }

    @Override
    public String getName() {
        return this.pickup.getType();
    }

    @Override
    public Location getLocation() {
        return this.pickup.getLocation();
    }

    @Override
    public double getTheoreticalEarliestOperationStartTime() {
        return this.theoreticalEarliest;
    }

    @Override
    public double getTheoreticalLatestOperationStartTime() {
        return this.theoreticalLatest;
    }

    @Override
    public void setTheoreticalEarliestOperationStartTime(double earliest) {
        this.theoreticalEarliest = earliest;
    }

    @Override
    public void setTheoreticalLatestOperationStartTime(double latest) {
        this.theoreticalLatest = latest;
    }

    @Override
    public double getOperationTime() {
        return this.pickup.getServiceDuration();
    }

    @Override
    public double getArrTime() {
        return this.arrTime;
    }

    @Override
    public double getEndTime() {
        return this.depTime;
    }

    @Override
    public void setArrTime(double arrTime) {
        this.arrTime = arrTime;
    }

    @Override
    public void setEndTime(double endTime) {
        this.depTime = endTime;
    }

    @Override
    public TourActivity duplicate() {
        return new PickupService(this);
    }

    @Override
    public Service getJob() {
        return this.pickup;
    }

    public String toString() {
        return "[type=" + this.getName() + "][locationId=" + this.getLocation().getId() + "][size=" + this.getSize().toString() + "][twStart=" + Activities.round(this.getTheoreticalEarliestOperationStartTime()) + "][twEnd=" + Activities.round(this.getTheoreticalLatestOperationStartTime()) + "]";
    }

    @Override
    public Capacity getSize() {
        return this.pickup.getSize();
    }
}

