/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route.activity;

import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TourActivities {
    private final ArrayList<TourActivity> tourActivities = new ArrayList();
    private final Set<Job> jobs = new HashSet<Job>();
    private ReverseActivityIterator backward;

    public static TourActivities copyOf(TourActivities tourActivities) {
        return new TourActivities(tourActivities);
    }

    private TourActivities(TourActivities tour2copy) {
        for (TourActivity tourAct : tour2copy.getActivities()) {
            TourActivity newAct = tourAct.duplicate();
            this.tourActivities.add(newAct);
            this.addJob(newAct);
        }
    }

    public TourActivities() {
    }

    public List<TourActivity> getActivities() {
        return Collections.unmodifiableList(this.tourActivities);
    }

    public Iterator<TourActivity> iterator() {
        return this.tourActivities.iterator();
    }

    public boolean isEmpty() {
        return this.tourActivities.size() == 0;
    }

    public Collection<Job> getJobs() {
        return Collections.unmodifiableSet(this.jobs);
    }

    public boolean servesJob(Job job) {
        return this.jobs.contains(job);
    }

    public String toString() {
        return "[nuOfActivities=" + this.tourActivities.size() + "]";
    }

    public boolean removeJob(Job job) {
        boolean jobRemoved = false;
        if (!this.jobs.contains(job)) {
            return false;
        }
        jobRemoved = this.jobs.remove(job);
        boolean activityRemoved = false;
        Iterator<TourActivity> iterator = this.tourActivities.iterator();
        while (iterator.hasNext()) {
            Job underlyingJob;
            TourActivity c = iterator.next();
            if (!(c instanceof TourActivity.JobActivity) || !job.equals(underlyingJob = ((TourActivity.JobActivity)c).getJob())) continue;
            iterator.remove();
            activityRemoved = true;
        }
        assert (jobRemoved == activityRemoved) : "job removed, but belonging activity not.";
        return activityRemoved;
    }

    public boolean removeActivity(TourActivity activity) {
        Job job = null;
        if (activity instanceof TourActivity.JobActivity) {
            job = ((TourActivity.JobActivity)activity).getJob();
        }
        boolean jobIsAlsoAssociateToOtherActs = false;
        boolean actRemoved = false;
        ArrayList<TourActivity> acts = new ArrayList<TourActivity>(this.tourActivities);
        for (TourActivity act : acts) {
            if (act == activity) {
                this.tourActivities.remove(act);
                actRemoved = true;
                continue;
            }
            if (!(act instanceof TourActivity.JobActivity) || job == null || !((TourActivity.JobActivity)act).getJob().equals(job)) continue;
            jobIsAlsoAssociateToOtherActs = true;
        }
        if (!jobIsAlsoAssociateToOtherActs && actRemoved) {
            this.jobs.remove(job);
        }
        return actRemoved;
    }

    public void addActivity(int insertionIndex, TourActivity act) {
        assert (insertionIndex >= 0) : "insertionIndex < 0, this cannot be";
        if (insertionIndex < this.tourActivities.size()) {
            this.tourActivities.add(insertionIndex, act);
        } else if (insertionIndex >= this.tourActivities.size()) {
            this.tourActivities.add(act);
        }
        this.addJob(act);
    }

    public void addActivity(TourActivity act) {
        if (this.tourActivities.contains(act)) {
            throw new IllegalArgumentException("act " + act + " already in tour. cannot add act twice.");
        }
        this.tourActivities.add(act);
        this.addJob(act);
    }

    private void addJob(TourActivity act) {
        if (act instanceof TourActivity.JobActivity) {
            Job job = ((TourActivity.JobActivity)act).getJob();
            this.jobs.add(job);
        }
    }

    public int jobSize() {
        return this.jobs.size();
    }

    public Iterator<TourActivity> reverseActivityIterator() {
        if (this.backward == null) {
            this.backward = new ReverseActivityIterator(this.tourActivities);
        } else {
            this.backward.reset();
        }
        return this.backward;
    }

    public static class ReverseActivityIterator
    implements Iterator<TourActivity> {
        private List<TourActivity> acts;
        private int currentIndex;

        public ReverseActivityIterator(List<TourActivity> acts) {
            this.acts = acts;
            this.currentIndex = acts.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex >= 0;
        }

        @Override
        public TourActivity next() {
            TourActivity act = this.acts.get(this.currentIndex);
            --this.currentIndex;
            return act;
        }

        public void reset() {
            this.currentIndex = this.acts.size() - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

