/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.vehicle;

import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;

public class VehicleTypeImpl
implements VehicleType {
    private final String typeId;
    private final int capacity;
    private final String profile;
    private final VehicleCostParams vehicleCostParams;
    private final Capacity capacityDimensions;
    private final double maxVelocity;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeId == null ? 0 : this.typeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VehicleTypeImpl other = (VehicleTypeImpl)obj;
        return !(this.typeId == null ? other.typeId != null : !this.typeId.equals(other.typeId));
    }

    private VehicleTypeImpl(Builder builder) {
        this.typeId = builder.id;
        this.capacity = builder.capacity;
        this.maxVelocity = builder.maxVelo;
        this.vehicleCostParams = new VehicleCostParams(builder.fixedCost, builder.perTime, builder.perDistance, builder.perWaitingTime, builder.perServiceTime);
        this.capacityDimensions = builder.capacityDimensions;
        this.profile = builder.profile;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public VehicleCostParams getVehicleCostParams() {
        return this.vehicleCostParams;
    }

    public String toString() {
        return "[typeId=" + this.typeId + "]" + "[capacity=" + this.capacityDimensions + "]" + "[costs=" + this.vehicleCostParams + "]";
    }

    @Override
    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    @Override
    public Capacity getCapacityDimensions() {
        return this.capacityDimensions;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    public static class Builder {
        private String id;
        private int capacity = 0;
        private double maxVelo = Double.MAX_VALUE;
        private double fixedCost = 0.0;
        private double perDistance = 1.0;
        private double perTime = 0.0;
        private double perWaitingTime = 0.0;
        private double perServiceTime = 0.0;
        private String profile = "car";
        private Capacity.Builder capacityBuilder = Capacity.Builder.newInstance();
        private Capacity capacityDimensions = null;
        private boolean dimensionAdded = false;

        public static Builder newInstance(String id) {
            if (id == null) {
                throw new IllegalArgumentException();
            }
            return new Builder(id);
        }

        private Builder(String id) {
            this.id = id;
        }

        public Builder setMaxVelocity(double inMeterPerSeconds) {
            if (inMeterPerSeconds < 0.0) {
                throw new IllegalArgumentException("velocity cannot be smaller than zero");
            }
            this.maxVelo = inMeterPerSeconds;
            return this;
        }

        public Builder setFixedCost(double fixedCost) {
            if (fixedCost < 0.0) {
                throw new IllegalArgumentException("fixed costs cannot be smaller than zero");
            }
            this.fixedCost = fixedCost;
            return this;
        }

        public Builder setCostPerDistance(double perDistance) {
            if (perDistance < 0.0) {
                throw new IllegalArgumentException("cost per distance must not be smaller than zero");
            }
            this.perDistance = perDistance;
            return this;
        }

        @Deprecated
        public Builder setCostPerTime(double perTime) {
            if (perTime < 0.0) {
                throw new IllegalArgumentException();
            }
            this.perTime = perTime;
            return this;
        }

        public Builder setCostPerTransportTime(double perTime) {
            if (perTime < 0.0) {
                throw new IllegalArgumentException();
            }
            this.perTime = perTime;
            return this;
        }

        public Builder setCostPerWaitingTime(double perWaitingTime) {
            if (perWaitingTime < 0.0) {
                throw new IllegalArgumentException();
            }
            this.perWaitingTime = perWaitingTime;
            return this;
        }

        public Builder setCostPerServiceTime(double perServiceTime) {
            this.perServiceTime = perServiceTime;
            return this;
        }

        public VehicleTypeImpl build() {
            if (this.capacityDimensions == null) {
                this.capacityDimensions = this.capacityBuilder.build();
            }
            return new VehicleTypeImpl(this);
        }

        public Builder addCapacityDimension(int dimIndex, int dimVal) {
            if (dimVal < 0) {
                throw new IllegalArgumentException("capacity value cannot be negative");
            }
            if (this.capacityDimensions != null) {
                throw new IllegalArgumentException("either build your dimension with build your dimensions with addCapacityDimension(int dimIndex, int dimVal) or set the already built dimensions with .setCapacityDimensions(Capacity capacity).You used both methods.");
            }
            this.dimensionAdded = true;
            this.capacityBuilder.addDimension(dimIndex, dimVal);
            return this;
        }

        public Builder setCapacityDimensions(Capacity capacity) {
            if (this.dimensionAdded) {
                throw new IllegalArgumentException("either build your dimension with build your dimensions with addCapacityDimension(int dimIndex, int dimVal) or set the already built dimensions with .setCapacityDimensions(Capacity capacity).You used both methods.");
            }
            this.capacityDimensions = capacity;
            return this;
        }

        public Builder setProfile(String profile) {
            this.profile = profile;
            return this;
        }
    }

    public static class VehicleCostParams {
        public final double fix;
        @Deprecated
        public final double perTimeUnit;
        public final double perTransportTimeUnit;
        public final double perDistanceUnit;
        public final double perWaitingTimeUnit;
        public final double perServiceTimeUnit;

        public static VehicleCostParams newInstance(double fix, double perTimeUnit, double perDistanceUnit) {
            return new VehicleCostParams(fix, perTimeUnit, perDistanceUnit);
        }

        private VehicleCostParams(double fix, double perTimeUnit, double perDistanceUnit) {
            this.fix = fix;
            this.perTimeUnit = perTimeUnit;
            this.perTransportTimeUnit = perTimeUnit;
            this.perDistanceUnit = perDistanceUnit;
            this.perWaitingTimeUnit = 0.0;
            this.perServiceTimeUnit = 0.0;
        }

        public VehicleCostParams(double fix, double perTimeUnit, double perDistanceUnit, double perWaitingTimeUnit) {
            this.fix = fix;
            this.perTimeUnit = perTimeUnit;
            this.perTransportTimeUnit = perTimeUnit;
            this.perDistanceUnit = perDistanceUnit;
            this.perWaitingTimeUnit = perWaitingTimeUnit;
            this.perServiceTimeUnit = 0.0;
        }

        public VehicleCostParams(double fix, double perTimeUnit, double perDistanceUnit, double perWaitingTimeUnit, double perServiceTimeUnit) {
            this.fix = fix;
            this.perTimeUnit = perTimeUnit;
            this.perTransportTimeUnit = perTimeUnit;
            this.perDistanceUnit = perDistanceUnit;
            this.perWaitingTimeUnit = perWaitingTimeUnit;
            this.perServiceTimeUnit = perServiceTimeUnit;
        }

        public String toString() {
            return "[fixed=" + this.fix + "][perTime=" + this.perTransportTimeUnit + "][perDistance=" + this.perDistanceUnit + "][perWaitingTimeUnit=" + this.perWaitingTimeUnit + "]";
        }
    }
}

