/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.AbstractForwardVehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.cost.TransportDistance;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Locations;

public class ManhattanCosts
extends AbstractForwardVehicleRoutingTransportCosts
implements TransportDistance {
    public double speed = 1.0;
    private Locations locations;

    public ManhattanCosts(Locations locations) {
        this.locations = locations;
    }

    public ManhattanCosts() {
    }

    @Override
    public double getTransportCost(Location from, Location to, double time, Driver driver, Vehicle vehicle) {
        double distance;
        try {
            distance = this.calculateDistance(from, to);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("cannot calculate euclidean distance. coordinates are missing. either add coordinates or use another transport-cost-calculator.");
        }
        double costs = distance;
        if (vehicle != null && vehicle.getType() != null) {
            costs = distance * vehicle.getType().getVehicleCostParams().perDistanceUnit;
        }
        return costs;
    }

    @Override
    public double getTransportTime(Location from, Location to, double time, Driver driver, Vehicle vehicle) {
        return this.calculateDistance(from, to) / this.speed;
    }

    private double calculateDistance(Location fromLocation, Location toLocation) {
        Coordinate from = null;
        Coordinate to = null;
        if (fromLocation.getCoordinate() != null & toLocation.getCoordinate() != null) {
            from = fromLocation.getCoordinate();
            to = toLocation.getCoordinate();
        } else if (this.locations != null) {
            from = this.locations.getCoord(fromLocation.getId());
            to = this.locations.getCoord(toLocation.getId());
        }
        if (from == null || to == null) {
            throw new NullPointerException();
        }
        return this.calculateDistance(from, to);
    }

    private double calculateDistance(Coordinate from, Coordinate to) {
        return Math.abs(from.getX() - to.getX()) + Math.abs(from.getY() - to.getY());
    }

    @Override
    public double getDistance(Location from, Location to, double departureTime, Vehicle vehicle) {
        return this.calculateDistance(from, to);
    }
}

