/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    private static Logger log = LoggerFactory.getLogger(Resource.class);

    public static final URL getAsURL(String filename) {
        URL url = Resource.class.getClassLoader().getResource(filename);
        if (url != null) {
            return url;
        }
        log.debug("resource: " + filename + " is unreachable by the current class loader, try the filesystem");
        File file = new File(filename);
        if (!file.exists()) {
            log.debug("resource: " + filename + " do not exists on the filesystem");
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            log.debug("resource: " + filename + " exists on the filesystem, but its URL is invalid: " + e.getMessage());
            return null;
        }
    }

    public static final InputStream getAsInputStream(String filename) {
        InputStream stream = Resource.class.getClassLoader().getResourceAsStream(filename);
        if (stream != null) {
            return stream;
        }
        log.debug("resource: " + filename + " is unreachable by the current class loader, try the filesystem");
        File file = new File(filename);
        if (!file.exists()) {
            log.debug("resource: " + filename + " do not exists on the filesystem");
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.debug("resource: " + filename + " exists on the filesystem, but its URL is invalid: " + e.getMessage());
            return null;
        }
    }
}

