/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.state.StateId;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.EuclideanDistanceCalculator;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.core.util.VehicleRoutingTransportCostsMatrix;
import com.graphhopper.jsprit.io.problem.VrpXMLReader;
import java.util.Collection;

public class AdditionalDistanceConstraintExample {
    public static void main(String[] args) {
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new VrpXMLReader(vrpBuilder).read("input/pickups_and_deliveries_solomon_r101_withoutTWs.xml");
        VehicleRoutingTransportCostsMatrix costMatrix = AdditionalDistanceConstraintExample.createMatrix(vrpBuilder);
        vrpBuilder.setRoutingCost((VehicleRoutingTransportCosts)costMatrix);
        VehicleRoutingProblem vrp = vrpBuilder.build();
        StateManager stateManager = new StateManager(vrp);
        StateId distanceStateId = stateManager.createStateId("distance");
        stateManager.addStateUpdater((StateUpdater)new DistanceUpdater(distanceStateId, stateManager, costMatrix));
        ConstraintManager constraintManager = new ConstraintManager(vrp, (RouteAndActivityStateGetter)stateManager);
        constraintManager.addConstraint((HardActivityConstraint)new DistanceConstraint(120.0, distanceStateId, stateManager, costMatrix), ConstraintManager.Priority.CRITICAL);
        VehicleRoutingAlgorithm vra = Jsprit.Builder.newInstance((VehicleRoutingProblem)vrp).setStateAndConstraintManager(stateManager, constraintManager).buildAlgorithm();
        vra.setMaxIterations(250);
        Collection solutions = vra.searchSolutions();
        SolutionPrinter.print((VehicleRoutingProblem)vrp, (VehicleRoutingProblemSolution)Solutions.bestOf((Collection)solutions), (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new Plotter(vrp, Solutions.bestOf((Collection)solutions)).plot("output/plot", "plot");
    }

    private static VehicleRoutingTransportCostsMatrix createMatrix(VehicleRoutingProblem.Builder vrpBuilder) {
        VehicleRoutingTransportCostsMatrix.Builder matrixBuilder = VehicleRoutingTransportCostsMatrix.Builder.newInstance((boolean)true);
        for (String from : vrpBuilder.getLocationMap().keySet()) {
            for (String to : vrpBuilder.getLocationMap().keySet()) {
                Coordinate fromCoord = (Coordinate)vrpBuilder.getLocationMap().get(from);
                Coordinate toCoord = (Coordinate)vrpBuilder.getLocationMap().get(to);
                double distance = EuclideanDistanceCalculator.calculateDistance((Coordinate)fromCoord, (Coordinate)toCoord);
                matrixBuilder.addTransportDistance(from, to, distance);
                matrixBuilder.addTransportTime(from, to, distance / 2.0);
            }
        }
        return matrixBuilder.build();
    }

    static class DistanceConstraint
    implements HardActivityConstraint {
        private final StateManager stateManager;
        private final VehicleRoutingTransportCostsMatrix costsMatrix;
        private final double maxDistance;
        private final StateId distanceStateId;

        DistanceConstraint(double maxDistance, StateId distanceStateId, StateManager stateManager, VehicleRoutingTransportCostsMatrix transportCosts) {
            this.costsMatrix = transportCosts;
            this.maxDistance = maxDistance;
            this.stateManager = stateManager;
            this.distanceStateId = distanceStateId;
        }

        public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext context, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double v) {
            double newRouteDistance;
            double additionalDistance = this.getDistance(prevAct, newAct) + this.getDistance(newAct, nextAct) - this.getDistance(prevAct, nextAct);
            Double routeDistance = (Double)this.stateManager.getRouteState(context.getRoute(), this.distanceStateId, Double.class);
            if (routeDistance == null) {
                routeDistance = 0.0;
            }
            if ((newRouteDistance = routeDistance + additionalDistance) > this.maxDistance) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
            }
            return HardActivityConstraint.ConstraintsStatus.FULFILLED;
        }

        double getDistance(TourActivity from, TourActivity to) {
            return this.costsMatrix.getDistance(from.getLocation().getId(), to.getLocation().getId());
        }
    }

    static class DistanceUpdater
    implements StateUpdater,
    ActivityVisitor {
        private final StateManager stateManager;
        private final VehicleRoutingTransportCostsMatrix costMatrix;
        private final StateId distanceStateId;
        private VehicleRoute vehicleRoute;
        private double distance = 0.0;
        private TourActivity prevAct;

        public DistanceUpdater(StateId distanceStateId, StateManager stateManager, VehicleRoutingTransportCostsMatrix transportCosts) {
            this.costMatrix = transportCosts;
            this.stateManager = stateManager;
            this.distanceStateId = distanceStateId;
        }

        public void begin(VehicleRoute vehicleRoute) {
            this.distance = 0.0;
            this.prevAct = vehicleRoute.getStart();
            this.vehicleRoute = vehicleRoute;
        }

        public void visit(TourActivity tourActivity) {
            this.distance += this.getDistance(this.prevAct, tourActivity);
            this.prevAct = tourActivity;
        }

        public void finish() {
            this.distance += this.getDistance(this.prevAct, (TourActivity)this.vehicleRoute.getEnd());
            this.stateManager.putRouteState(this.vehicleRoute, this.distanceStateId, (Object)this.distance);
        }

        double getDistance(TourActivity from, TourActivity to) {
            return this.costMatrix.getDistance(from.getLocation().getId(), to.getLocation().getId());
        }
    }
}

