/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.AlgorithmSearchProgressChartListener;
import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.state.StateId;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.driver.DriverImpl;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ReverseActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.CrowFlyCosts;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.util.Examples;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BicycleMessenger {
    public static void main(String[] args) throws IOException {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder problemBuilder = VehicleRoutingProblem.Builder.newInstance();
        problemBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        BicycleMessenger.readEnvelopes(problemBuilder);
        BicycleMessenger.readMessengers(problemBuilder);
        CrowFlyCosts routingCosts = new CrowFlyCosts(problemBuilder.getLocations());
        problemBuilder.setRoutingCost((VehicleRoutingTransportCosts)routingCosts);
        VehicleRoutingProblem bicycleMessengerProblem = problemBuilder.build();
        Map<String, Double> nearestMessengers = BicycleMessenger.getNearestMessengers((VehicleRoutingTransportCosts)routingCosts, problemBuilder.getAddedJobs(), problemBuilder.getAddedVehicles());
        StateManager stateManager = new StateManager(bicycleMessengerProblem);
        StateId latest_act_arrival_time_stateId = stateManager.createStateId("latest-act-arrival-time");
        stateManager.addStateUpdater((StateUpdater)new UpdateLatestActivityStartTimes(latest_act_arrival_time_stateId, stateManager, (VehicleRoutingTransportCosts)routingCosts, nearestMessengers));
        stateManager.updateLoadStates();
        ConstraintManager constraintManager = new ConstraintManager(bicycleMessengerProblem, (RouteAndActivityStateGetter)stateManager);
        constraintManager.addLoadConstraint();
        constraintManager.addConstraint((HardActivityConstraint)new ThreeTimesLessThanBestDirectRouteConstraint(latest_act_arrival_time_stateId, nearestMessengers, (VehicleRoutingTransportCosts)routingCosts, (RouteAndActivityStateGetter)stateManager), ConstraintManager.Priority.CRITICAL);
        constraintManager.addConstraint((HardRouteConstraint)new IgnoreMessengerThatCanNeverMeetTimeRequirements(nearestMessengers, (VehicleRoutingTransportCosts)routingCosts));
        VehicleRoutingAlgorithm algorithm = Jsprit.Builder.newInstance((VehicleRoutingProblem)bicycleMessengerProblem).setStateAndConstraintManager(stateManager, constraintManager).buildAlgorithm();
        algorithm.setMaxIterations(2000);
        algorithm.addListener((VehicleRoutingAlgorithmListener)new AlgorithmSearchProgressChartListener("output/progress.png"));
        Collection solutions = algorithm.searchSolutions();
        BicycleMessenger.validateSolution(Solutions.bestOf((Collection)solutions), bicycleMessengerProblem, nearestMessengers);
        SolutionPrinter.print((VehicleRoutingProblem)bicycleMessengerProblem, (VehicleRoutingProblemSolution)Solutions.bestOf((Collection)solutions), (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        Plotter plotter = new Plotter(bicycleMessengerProblem);
        plotter.plotShipments(true);
        plotter.plot("output/bicycleMessengerProblem.png", "bicycleMessenger");
        Plotter plotter1 = new Plotter(bicycleMessengerProblem, Solutions.bestOf((Collection)solutions));
        plotter1.setLabel(Plotter.Label.ID);
        plotter1.plotShipments(false);
        plotter1.plot("output/bicycleMessengerSolution.png", "bicycleMessenger");
        new GraphStreamViewer(bicycleMessengerProblem).labelWith(GraphStreamViewer.Label.ID).setRenderShipments(true).setRenderDelay(150L).display();
        new GraphStreamViewer(bicycleMessengerProblem, Solutions.bestOf((Collection)solutions)).setGraphStreamFrameScalingFactor(1.5).setCameraView(12500.0, 55000.0, 0.25).labelWith(GraphStreamViewer.Label.ACTIVITY).setRenderShipments(true).setRenderDelay(150L).display();
    }

    private static void validateSolution(VehicleRoutingProblemSolution bestOf, VehicleRoutingProblem bicycleMessengerProblem, Map<String, Double> nearestMessengers) {
        for (VehicleRoute route : bestOf.getRoutes()) {
            for (TourActivity act : route.getActivities()) {
                if (!(act.getArrTime() > 3.0 * nearestMessengers.get(((TourActivity.JobActivity)act).getJob().getId()))) continue;
                SolutionPrinter.print((VehicleRoutingProblem)bicycleMessengerProblem, (VehicleRoutingProblemSolution)bestOf, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
                throw new IllegalStateException("three times less than ... constraint broken. this must not be. act.getArrTime(): " + act.getArrTime() + " allowed: " + 3.0 * nearestMessengers.get(((TourActivity.JobActivity)act).getJob().getId()));
            }
        }
    }

    static Map<String, Double> getNearestMessengers(VehicleRoutingTransportCosts routingCosts, Collection<Job> envelopes, Collection<Vehicle> messengers) {
        HashMap<String, Double> nearestMessengers = new HashMap<String, Double>();
        for (Job envelope : envelopes) {
            double minDirect = Double.MAX_VALUE;
            for (Vehicle m : messengers) {
                double direct = BicycleMessenger.getTimeOfDirectRoute(envelope, m, routingCosts);
                if (!(direct < minDirect)) continue;
                minDirect = direct;
            }
            nearestMessengers.put(envelope.getId(), minDirect);
        }
        return nearestMessengers;
    }

    static double getTimeOfDirectRoute(Job job, Vehicle v, VehicleRoutingTransportCosts routingCosts) {
        Shipment envelope = (Shipment)job;
        return routingCosts.getTransportTime(v.getStartLocation(), envelope.getPickupLocation(), 0.0, (Driver)DriverImpl.noDriver(), v) + routingCosts.getTransportTime(envelope.getPickupLocation(), envelope.getDeliveryLocation(), 0.0, (Driver)DriverImpl.noDriver(), v);
    }

    private static void readEnvelopes(VehicleRoutingProblem.Builder problemBuilder) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File("input/bicycle_messenger_demand.txt")));
        boolean firstLine = true;
        while ((line = reader.readLine()) != null) {
            if (firstLine) {
                firstLine = false;
                continue;
            }
            String[] tokens = line.split("\\s+");
            Shipment envelope = Shipment.Builder.newInstance((String)tokens[1]).addSizeDimension(0, 1).setPickupLocation(Location.Builder.newInstance().setCoordinate(Coordinate.newInstance((double)Double.parseDouble(tokens[2]), (double)Double.parseDouble(tokens[3]))).build()).setDeliveryLocation(Location.Builder.newInstance().setCoordinate(Coordinate.newInstance((double)Double.parseDouble(tokens[4]), (double)Double.parseDouble(tokens[5]))).build()).build();
            problemBuilder.addJob((AbstractJob)envelope);
        }
        reader.close();
    }

    private static void readMessengers(VehicleRoutingProblem.Builder problemBuilder) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File("input/bicycle_messenger_supply.txt")));
        boolean firstLine = true;
        VehicleTypeImpl messengerType = VehicleTypeImpl.Builder.newInstance((String)"messengerType").addCapacityDimension(0, 15).setCostPerDistance(1.0).build();
        while ((line = reader.readLine()) != null) {
            if (firstLine) {
                firstLine = false;
                continue;
            }
            String[] tokens = line.split("\\s+");
            VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)tokens[1]).setStartLocation(Location.Builder.newInstance().setCoordinate(Coordinate.newInstance((double)Double.parseDouble(tokens[2]), (double)Double.parseDouble(tokens[3]))).build()).setReturnToDepot(false).setType((VehicleType)messengerType).build();
            problemBuilder.addVehicle((AbstractVehicle)vehicle);
        }
        reader.close();
    }

    static class UpdateLatestActivityStartTimes
    implements StateUpdater,
    ReverseActivityVisitor {
        private final StateManager stateManager;
        private final VehicleRoutingTransportCosts routingCosts;
        private final Map<String, Double> bestMessengers;
        private VehicleRoute route;
        private TourActivity prevAct;
        private double latest_arrTime_at_prevAct;
        private final StateId latest_act_arrival_time_stateId;

        public UpdateLatestActivityStartTimes(StateId latest_act_arrival_time, StateManager stateManager, VehicleRoutingTransportCosts routingCosts, Map<String, Double> bestMessengers) {
            this.stateManager = stateManager;
            this.routingCosts = routingCosts;
            this.bestMessengers = bestMessengers;
            this.latest_act_arrival_time_stateId = latest_act_arrival_time;
        }

        public void begin(VehicleRoute route) {
            this.route = route;
            this.latest_arrTime_at_prevAct = route.getEnd().getTheoreticalLatestOperationStartTime();
            this.prevAct = route.getEnd();
        }

        public void visit(TourActivity currAct) {
            double timeOfNearestMessenger = this.bestMessengers.get(((TourActivity.JobActivity)currAct).getJob().getId());
            double potential_latest_arrTime_at_currAct = this.latest_arrTime_at_prevAct - this.routingCosts.getBackwardTransportTime(currAct.getLocation(), this.prevAct.getLocation(), this.latest_arrTime_at_prevAct, this.route.getDriver(), this.route.getVehicle()) - currAct.getOperationTime();
            double latest_arrTime_at_currAct = Math.min(3.0 * timeOfNearestMessenger, potential_latest_arrTime_at_currAct);
            this.stateManager.putActivityState(currAct, this.latest_act_arrival_time_stateId, (Object)latest_arrTime_at_currAct);
            assert (currAct.getArrTime() <= latest_arrTime_at_currAct) : "this must not be since it breaks condition; actArrTime: " + currAct.getArrTime() + " latestArrTime: " + latest_arrTime_at_currAct + " vehicle: " + this.route.getVehicle().getId();
            this.latest_arrTime_at_prevAct = latest_arrTime_at_currAct;
            this.prevAct = currAct;
        }

        public void finish() {
        }
    }

    static class IgnoreMessengerThatCanNeverMeetTimeRequirements
    implements HardRouteConstraint {
        private final Map<String, Double> bestMessengers;
        private final VehicleRoutingTransportCosts routingCosts;

        public IgnoreMessengerThatCanNeverMeetTimeRequirements(Map<String, Double> bestMessengers, VehicleRoutingTransportCosts routingCosts) {
            this.bestMessengers = bestMessengers;
            this.routingCosts = routingCosts;
        }

        public boolean fulfilled(JobInsertionContext insertionContext) {
            double timeOfNearestMessenger;
            double timeOfDirectRoute = BicycleMessenger.getTimeOfDirectRoute(insertionContext.getJob(), insertionContext.getNewVehicle(), this.routingCosts);
            return !(timeOfDirectRoute > 3.0 * (timeOfNearestMessenger = this.bestMessengers.get(insertionContext.getJob().getId()).doubleValue()));
        }
    }

    static class ThreeTimesLessThanBestDirectRouteConstraint
    implements HardActivityConstraint {
        private final VehicleRoutingTransportCosts routingCosts;
        private final RouteAndActivityStateGetter stateManager;
        private final Map<String, Double> bestMessengers;
        private final StateId latest_act_arrival_time_stateId;

        public ThreeTimesLessThanBestDirectRouteConstraint(StateId latest_act_arrival_time, Map<String, Double> nearestMessengers, VehicleRoutingTransportCosts routingCosts, RouteAndActivityStateGetter stateManager) {
            this.bestMessengers = nearestMessengers;
            this.routingCosts = routingCosts;
            this.stateManager = stateManager;
            this.latest_act_arrival_time_stateId = latest_act_arrival_time;
        }

        public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
            double directTimeOfNearestMessenger;
            double arrTime_at_nextAct_onDirectRoute = prevActDepTime + this.routingCosts.getTransportTime(prevAct.getLocation(), nextAct.getLocation(), prevActDepTime, iFacts.getNewDriver(), iFacts.getNewVehicle());
            Double latest_arrTime_at_nextAct = (Double)this.stateManager.getActivityState(nextAct, this.latest_act_arrival_time_stateId, Double.class);
            if (latest_arrTime_at_nextAct == null) {
                latest_arrTime_at_nextAct = nextAct.getTheoreticalLatestOperationStartTime();
            }
            if (arrTime_at_nextAct_onDirectRoute > latest_arrTime_at_nextAct) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
            }
            double arrTime_at_newAct = prevActDepTime + this.routingCosts.getTransportTime(prevAct.getLocation(), newAct.getLocation(), prevActDepTime, iFacts.getNewDriver(), iFacts.getNewVehicle());
            if (arrTime_at_newAct > 3.0 * (directTimeOfNearestMessenger = this.bestMessengers.get(((TourActivity.JobActivity)newAct).getJob().getId()).doubleValue())) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
            }
            double departureTime_at_newAct = arrTime_at_newAct + newAct.getOperationTime();
            double latest_arrTime_at_newAct = latest_arrTime_at_nextAct - this.routingCosts.getTransportTime(newAct.getLocation(), nextAct.getLocation(), departureTime_at_newAct, iFacts.getNewDriver(), iFacts.getNewVehicle());
            if (arrTime_at_newAct > latest_arrTime_at_newAct) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
            }
            double arrTime_at_nextAct = departureTime_at_newAct + this.routingCosts.getTransportTime(newAct.getLocation(), nextAct.getLocation(), departureTime_at_newAct, iFacts.getNewDriver(), iFacts.getNewVehicle());
            if (arrTime_at_nextAct > latest_arrTime_at_nextAct) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
            }
            return HardActivityConstraint.ConstraintsStatus.FULFILLED;
        }
    }
}

