/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;

public class BreakExample {
    public static void main(String[] args) {
        boolean WEIGHT_INDEX = false;
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 2).setCostPerWaitingTime(1.0);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)"v1");
        vehicleBuilder.setStartLocation(Location.newInstance((double)10.0, (double)10.0));
        Break myFirstBreak = (Break)Break.Builder.newInstance((String)"myFirstBreak").setTimeWindow(TimeWindow.newInstance((double)10.0, (double)15.0)).setServiceTime(100.0).build();
        vehicleBuilder.setBreak(myFirstBreak);
        vehicleBuilder.setType((VehicleType)vehicleType);
        VehicleImpl vehicle = vehicleBuilder.build();
        VehicleImpl v2 = VehicleImpl.Builder.newInstance((String)"v2").setStartLocation(Location.newInstance((double)0.0, (double)10.0)).setType((VehicleType)vehicleType).setBreak((Break)Break.Builder.newInstance((String)"mySecondBreak").setTimeWindow(TimeWindow.newInstance((double)5.0, (double)10.0)).setServiceTime(10.0).build()).build();
        Service service1 = Service.Builder.newInstance((String)"1").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)7.0)).build();
        Service service2 = Service.Builder.newInstance((String)"2").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)13.0)).build();
        Service service3 = Service.Builder.newInstance((String)"3").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)7.0)).build();
        Service service4 = Service.Builder.newInstance((String)"4").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)13.0)).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle);
        vrpBuilder.addJob((AbstractJob)service1).addJob((AbstractJob)service2).addJob((AbstractJob)service3).addJob((AbstractJob)service4).addVehicle((AbstractVehicle)v2);
        vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        VehicleRoutingProblem problem = vrpBuilder.build();
        VehicleRoutingAlgorithm algorithm = Jsprit.Builder.newInstance((VehicleRoutingProblem)problem).setProperty(Jsprit.Strategy.CLUSTER_REGRET, "0.").setProperty(Jsprit.Strategy.CLUSTER_BEST, "0.").buildAlgorithm();
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        SolutionPrinter.print((VehicleRoutingProblem)problem, (VehicleRoutingProblemSolution)bestSolution, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new Plotter(problem, bestSolution).plot("output/plot", "breaks");
    }
}

