/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.AlgorithmEventsRecorder;
import com.graphhopper.jsprit.analysis.toolbox.AlgorithmEventsViewer;
import com.graphhopper.jsprit.core.algorithm.PrettyAlgorithmBuilder;
import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.SearchStrategyModule;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.acceptor.GreedyAcceptance;
import com.graphhopper.jsprit.core.algorithm.acceptor.SolutionAcceptor;
import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.module.RuinAndRecreateModule;
import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.DefaultScorer;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionBuilder;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculatorLight;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculatorLightFactory;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertionFast;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoringFunction;
import com.graphhopper.jsprit.core.algorithm.ruin.RadialRuinStrategyFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.RandomRuinStrategyFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.distance.AvgServiceAndShipmentDistance;
import com.graphhopper.jsprit.core.algorithm.ruin.distance.JobDistance;
import com.graphhopper.jsprit.core.algorithm.selector.SelectBest;
import com.graphhopper.jsprit.core.algorithm.selector.SolutionSelector;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.analysis.SolutionAnalyser;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.cost.TransportDistance;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.SolutionCostCalculator;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.FiniteFleetManagerFactory;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.instance.reader.CordeauReader;
import com.graphhopper.jsprit.util.Examples;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class BuildAlgorithmFromScratch {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new CordeauReader(vrpBuilder).read("input/p08");
        VehicleRoutingProblem vrp = vrpBuilder.build();
        VehicleRoutingAlgorithm vra = BuildAlgorithmFromScratch.createAlgorithm(vrp);
        vra.setMaxIterations(100);
        AlgorithmEventsRecorder eventsRecorder = new AlgorithmEventsRecorder(vrp, "output/events.dgs.gz");
        eventsRecorder.setRecordingRange(90, 100);
        vra.addListener((VehicleRoutingAlgorithmListener)eventsRecorder);
        VehicleRoutingProblemSolution solution = Solutions.bestOf((Collection)vra.searchSolutions());
        SolutionPrinter.print((VehicleRoutingProblem)vrp, (VehicleRoutingProblemSolution)solution, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        AlgorithmEventsViewer viewer = new AlgorithmEventsViewer();
        viewer.setRuinDelay(3L);
        viewer.setRecreationDelay(1L);
        viewer.display("output/events.dgs.gz");
    }

    public static VehicleRoutingAlgorithm createAlgorithm(VehicleRoutingProblem vrp) {
        VehicleFleetManager fleetManager = new FiniteFleetManagerFactory(vrp.getVehicles()).createFleetManager();
        StateManager stateManager = new StateManager(vrp);
        ConstraintManager constraintManager = new ConstraintManager(vrp, (RouteAndActivityStateGetter)stateManager);
        MyBestStrategy best = new MyBestStrategy(vrp, fleetManager, stateManager, constraintManager);
        InsertionBuilder iBuilder = new InsertionBuilder(vrp, fleetManager, stateManager, constraintManager);
        iBuilder.setInsertionStrategy(InsertionBuilder.Strategy.REGRET);
        RegretInsertionFast regret = (RegretInsertionFast)iBuilder.build();
        DefaultScorer scoringFunction = new DefaultScorer(vrp);
        scoringFunction.setDepotDistanceParam(0.2);
        scoringFunction.setTimeWindowParam(-0.2);
        regret.setScoringFunction((ScoringFunction)scoringFunction);
        RuinStrategy randomRuin = new RandomRuinStrategyFactory(0.5).createStrategy(vrp);
        RuinStrategy radialRuin = new RadialRuinStrategyFactory(0.3, (JobDistance)new AvgServiceAndShipmentDistance(vrp.getTransportCosts())).createStrategy(vrp);
        SolutionCostCalculator objectiveFunction = BuildAlgorithmFromScratch.getObjectiveFunction(vrp);
        SearchStrategy firstStrategy = new SearchStrategy("firstStrategy", (SolutionSelector)new SelectBest(), (SolutionAcceptor)new GreedyAcceptance(1), objectiveFunction);
        firstStrategy.addModule((SearchStrategyModule)new RuinAndRecreateModule("randRuinRegretIns", (InsertionStrategy)regret, randomRuin));
        SearchStrategy secondStrategy = new SearchStrategy("secondStrategy", (SolutionSelector)new SelectBest(), (SolutionAcceptor)new GreedyAcceptance(1), objectiveFunction);
        secondStrategy.addModule((SearchStrategyModule)new RuinAndRecreateModule("radRuinRegretIns", (InsertionStrategy)regret, radialRuin));
        SearchStrategy thirdStrategy = new SearchStrategy("thirdStrategy", (SolutionSelector)new SelectBest(), (SolutionAcceptor)new GreedyAcceptance(1), objectiveFunction);
        secondStrategy.addModule((SearchStrategyModule)new RuinAndRecreateModule("radRuinBestIns", (InsertionStrategy)regret, radialRuin));
        PrettyAlgorithmBuilder prettyAlgorithmBuilder = PrettyAlgorithmBuilder.newInstance((VehicleRoutingProblem)vrp, (VehicleFleetManager)fleetManager, (StateManager)stateManager, (ConstraintManager)constraintManager);
        final VehicleRoutingAlgorithm vra = prettyAlgorithmBuilder.withStrategy(firstStrategy, 0.5).withStrategy(secondStrategy, 0.5).withStrategy(thirdStrategy, 0.2).addCoreStateAndConstraintStuff().constructInitialSolutionWith((InsertionStrategy)regret, objectiveFunction).build();
        IterationStartsListener strategyAdaptor = new IterationStartsListener(){

            public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
                if (i == 50) {
                    vra.getSearchStrategyManager().informStrategyWeightChanged("firstStrategy", 0.0);
                    System.out.println("switched off firstStrategy");
                }
                if (i == 90) {
                    vra.getSearchStrategyManager().informStrategyWeightChanged("firstStrategy", 0.7);
                    System.out.println("switched on firstStrategy again with higher weight");
                }
            }
        };
        vra.addListener((VehicleRoutingAlgorithmListener)strategyAdaptor);
        return vra;
    }

    private static SolutionCostCalculator getObjectiveFunction(final VehicleRoutingProblem vrp) {
        return new SolutionCostCalculator(){

            public double getCosts(VehicleRoutingProblemSolution solution) {
                SolutionAnalyser analyser = new SolutionAnalyser(vrp, solution, new TransportDistance(){

                    public double getDistance(Location from, Location to, double departureTime, Vehicle vehicle) {
                        return vrp.getTransportCosts().getTransportCost(from, to, 0.0, null, null);
                    }
                });
                return analyser.getVariableTransportCosts() + (double)solution.getUnassignedJobs().size() * 500.0;
            }
        };
    }

    public static class MyBestStrategy
    extends AbstractInsertionStrategy {
        private JobInsertionCostsCalculatorLight insertionCalculator;

        public MyBestStrategy(VehicleRoutingProblem vrp, VehicleFleetManager fleetManager, StateManager stateManager, ConstraintManager constraintManager) {
            super(vrp);
            this.insertionCalculator = JobInsertionCostsCalculatorLightFactory.createStandardCalculator((VehicleRoutingProblem)vrp, (VehicleFleetManager)fleetManager, (StateManager)stateManager, (ConstraintManager)constraintManager);
        }

        public Collection<Job> insertUnassignedJobs(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
            ArrayList<Job> badJobs = new ArrayList<Job>();
            ArrayList<Job> unassigned = new ArrayList<Job>(unassignedJobs);
            Collections.shuffle(unassigned, this.random);
            for (Job j : unassigned) {
                InsertionData bestInsertionData = InsertionData.createEmptyInsertionData();
                VehicleRoute bestRoute = null;
                for (VehicleRoute r : vehicleRoutes) {
                    InsertionData insertionData = this.insertionCalculator.getInsertionData(j, r, bestInsertionData.getInsertionCost());
                    if (insertionData instanceof InsertionData.NoInsertionFound || !(insertionData.getInsertionCost() < bestInsertionData.getInsertionCost())) continue;
                    bestInsertionData = insertionData;
                    bestRoute = r;
                }
                VehicleRoute empty = VehicleRoute.emptyRoute();
                InsertionData insertionData = this.insertionCalculator.getInsertionData(j, empty, bestInsertionData.getInsertionCost());
                if (!(insertionData instanceof InsertionData.NoInsertionFound)) {
                    if (!(insertionData.getInsertionCost() < bestInsertionData.getInsertionCost())) continue;
                    vehicleRoutes.add(empty);
                    this.insertJob(j, insertionData, empty);
                    continue;
                }
                if (bestRoute != null) {
                    this.insertJob(j, bestInsertionData, bestRoute);
                    continue;
                }
                badJobs.add(j);
            }
            return badJobs;
        }
    }
}

