/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.AlgorithmEventsRecorder;
import com.graphhopper.jsprit.analysis.toolbox.AlgorithmEventsViewer;
import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.GreedySchrimpfFactory;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Solutions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class CircleExample {
    public static Collection<Coordinate> createCoordinates(double center_x, double center_y, double radius, double step) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (double theta = 0.0; theta < Math.PI * 2; theta += step) {
            double x = center_x + radius * Math.cos(theta);
            double y = center_y - radius * Math.sin(theta);
            coords.add(Coordinate.newInstance((double)x, (double)y));
        }
        return coords;
    }

    public static void main(String[] args) {
        File dir = new File("output");
        if (!dir.exists()) {
            System.out.println("creating directory ./output");
            boolean result = dir.mkdir();
            if (result) {
                System.out.println("./output created");
            }
        }
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        VehicleImpl v = VehicleImpl.Builder.newInstance((String)"v").setStartLocation(Location.Builder.newInstance().setCoordinate(Coordinate.newInstance((double)0.0, (double)0.0)).build()).build();
        vrpBuilder.addVehicle((AbstractVehicle)v);
        double step = 0.12566370614359174;
        Collection<Coordinate> circle = CircleExample.createCoordinates(0.0, 0.0, 20.0, step);
        int id = 1;
        for (Coordinate c : circle) {
            Service s = Service.Builder.newInstance((String)Integer.toString(id)).setLocation(Location.Builder.newInstance().setCoordinate(c).build()).build();
            vrpBuilder.addJob((AbstractJob)s);
            ++id;
        }
        VehicleRoutingProblem vrp = vrpBuilder.build();
        AlgorithmEventsRecorder eventsRecorder = new AlgorithmEventsRecorder(vrp, "output/events.dgs.gz");
        eventsRecorder.setRecordingRange(0, 50);
        VehicleRoutingAlgorithm vra = new GreedySchrimpfFactory().createAlgorithm(vrp);
        vra.setMaxIterations(50);
        vra.addListener((VehicleRoutingAlgorithmListener)eventsRecorder);
        VehicleRoutingProblemSolution solution = Solutions.bestOf((Collection)vra.searchSolutions());
        new Plotter(vrp, solution).plot("output/circle.png", "circleProblem");
        new GraphStreamViewer(vrp, solution).display();
        AlgorithmEventsViewer viewer = new AlgorithmEventsViewer();
        viewer.setRuinDelay(16L);
        viewer.setRecreationDelay(8L);
        viewer.display("output/events.dgs.gz");
    }
}

