/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.core.util.VehicleRoutingTransportCostsMatrix;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class CostMatrixExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleTypeImpl type = VehicleTypeImpl.Builder.newInstance((String)"type").addCapacityDimension(0, 2).setCostPerDistance(1.0).setCostPerTime(2.0).build();
        VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)"vehicle").setStartLocation(Location.newInstance((String)"0")).setType((VehicleType)type).build();
        Service s1 = Service.Builder.newInstance((String)"1").addSizeDimension(0, 1).setLocation(Location.newInstance((String)"1")).build();
        Service s2 = Service.Builder.newInstance((String)"2").addSizeDimension(0, 1).setLocation(Location.newInstance((String)"2")).build();
        Service s3 = Service.Builder.newInstance((String)"3").addSizeDimension(0, 1).setLocation(Location.newInstance((String)"3")).build();
        VehicleRoutingTransportCostsMatrix.Builder costMatrixBuilder = VehicleRoutingTransportCostsMatrix.Builder.newInstance((boolean)true);
        costMatrixBuilder.addTransportDistance("0", "1", 10.0);
        costMatrixBuilder.addTransportDistance("0", "2", 20.0);
        costMatrixBuilder.addTransportDistance("0", "3", 5.0);
        costMatrixBuilder.addTransportDistance("1", "2", 4.0);
        costMatrixBuilder.addTransportDistance("1", "3", 1.0);
        costMatrixBuilder.addTransportDistance("2", "3", 2.0);
        costMatrixBuilder.addTransportTime("0", "1", 10.0);
        costMatrixBuilder.addTransportTime("0", "2", 20.0);
        costMatrixBuilder.addTransportTime("0", "3", 5.0);
        costMatrixBuilder.addTransportTime("1", "2", 4.0);
        costMatrixBuilder.addTransportTime("1", "3", 1.0);
        costMatrixBuilder.addTransportTime("2", "3", 2.0);
        VehicleRoutingTransportCostsMatrix costMatrix = costMatrixBuilder.build();
        VehicleRoutingProblem vrp = VehicleRoutingProblem.Builder.newInstance().setFleetSize(VehicleRoutingProblem.FleetSize.INFINITE).setRoutingCost((VehicleRoutingTransportCosts)costMatrix).addVehicle((AbstractVehicle)vehicle).addJob((AbstractJob)s1).addJob((AbstractJob)s2).addJob((AbstractJob)s3).build();
        VehicleRoutingAlgorithm vra = Jsprit.createAlgorithm((VehicleRoutingProblem)vrp);
        Collection solutions = vra.searchSolutions();
        SolutionPrinter.print((VehicleRoutingProblemSolution)Solutions.bestOf((Collection)solutions));
        new Plotter(vrp, Solutions.bestOf((Collection)solutions)).plot("output/yo.png", "po");
    }
}

