/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.io.problem.VrpXMLWriter;
import com.graphhopper.jsprit.util.Examples;
import java.util.Arrays;
import java.util.Collection;

public class EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 2);
        vehicleTypeBuilder.setCostPerDistance(1.0);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder1 = VehicleImpl.Builder.newInstance((String)"vehicles@[10,10]");
        vehicleBuilder1.setStartLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)10.0, (double)10.0))).setReturnToDepot(false);
        vehicleBuilder1.setType((VehicleType)vehicleType);
        VehicleImpl vehicle1 = vehicleBuilder1.build();
        VehicleImpl.Builder vehicleBuilder2 = VehicleImpl.Builder.newInstance((String)"vehicles@[30,30]");
        vehicleBuilder2.setStartLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)30.0, (double)30.0))).setReturnToDepot(false);
        vehicleBuilder2.setType((VehicleType)vehicleType);
        VehicleImpl vehicle2 = vehicleBuilder2.build();
        VehicleImpl.Builder vehicleBuilder3 = VehicleImpl.Builder.newInstance((String)"vehicles@[10,30]");
        vehicleBuilder3.setStartLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)10.0, (double)30.0)));
        vehicleBuilder3.setType((VehicleType)vehicleType);
        VehicleImpl vehicle3 = vehicleBuilder3.build();
        VehicleImpl.Builder vehicleBuilder4 = VehicleImpl.Builder.newInstance((String)"vehicles@[30,10]");
        vehicleBuilder4.setStartLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)30.0, (double)10.0)));
        vehicleBuilder4.setType((VehicleType)vehicleType);
        VehicleImpl vehicle4 = vehicleBuilder4.build();
        Shipment shipment1 = Shipment.Builder.newInstance((String)"1").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)5.0, (double)7.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)6.0, (double)9.0))).build();
        Shipment shipment2 = Shipment.Builder.newInstance((String)"2").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)5.0, (double)13.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)6.0, (double)11.0))).build();
        Shipment shipment3 = Shipment.Builder.newInstance((String)"3").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)15.0, (double)7.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)14.0, (double)9.0))).build();
        Shipment shipment4 = Shipment.Builder.newInstance((String)"4").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)15.0, (double)13.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)14.0, (double)11.0))).build();
        Shipment shipment5 = Shipment.Builder.newInstance((String)"5").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)25.0, (double)27.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)26.0, (double)29.0))).build();
        Shipment shipment6 = Shipment.Builder.newInstance((String)"6").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)25.0, (double)33.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)26.0, (double)31.0))).build();
        Shipment shipment7 = Shipment.Builder.newInstance((String)"7").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)35.0, (double)27.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)34.0, (double)29.0))).build();
        Shipment shipment8 = Shipment.Builder.newInstance((String)"8").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)35.0, (double)33.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)34.0, (double)31.0))).build();
        Shipment shipment9 = Shipment.Builder.newInstance((String)"9").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)5.0, (double)27.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)6.0, (double)29.0))).build();
        Shipment shipment10 = Shipment.Builder.newInstance((String)"10").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)5.0, (double)33.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)6.0, (double)31.0))).build();
        Shipment shipment11 = Shipment.Builder.newInstance((String)"11").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)15.0, (double)27.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)14.0, (double)29.0))).build();
        Shipment shipment12 = Shipment.Builder.newInstance((String)"12").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)15.0, (double)33.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)14.0, (double)31.0))).build();
        Shipment shipment13 = Shipment.Builder.newInstance((String)"13").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)25.0, (double)7.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)26.0, (double)9.0))).build();
        Shipment shipment14 = Shipment.Builder.newInstance((String)"14").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)25.0, (double)13.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)26.0, (double)11.0))).build();
        Shipment shipment15 = Shipment.Builder.newInstance((String)"15").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)35.0, (double)7.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)34.0, (double)9.0))).build();
        Shipment shipment16 = Shipment.Builder.newInstance((String)"16").addSizeDimension(0, 1).setPickupLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)35.0, (double)13.0))).setDeliveryLocation(EnRoutePickupAndDeliveryWithMultipleDepotsAndOpenRoutesExample.loc(Coordinate.newInstance((double)34.0, (double)11.0))).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle1).addVehicle((AbstractVehicle)vehicle2).addVehicle((AbstractVehicle)vehicle3).addVehicle((AbstractVehicle)vehicle4);
        vrpBuilder.addJob((AbstractJob)shipment1).addJob((AbstractJob)shipment2).addJob((AbstractJob)shipment3).addJob((AbstractJob)shipment4);
        vrpBuilder.addJob((AbstractJob)shipment5).addJob((AbstractJob)shipment6).addJob((AbstractJob)shipment7).addJob((AbstractJob)shipment8);
        vrpBuilder.addJob((AbstractJob)shipment9).addJob((AbstractJob)shipment10).addJob((AbstractJob)shipment11).addJob((AbstractJob)shipment12);
        vrpBuilder.addJob((AbstractJob)shipment13).addJob((AbstractJob)shipment14).addJob((AbstractJob)shipment15).addJob((AbstractJob)shipment16);
        vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        VehicleRoutingProblem problem = vrpBuilder.build();
        VehicleRoutingAlgorithm algorithm = Jsprit.createAlgorithm((VehicleRoutingProblem)problem);
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        new VrpXMLWriter(problem, solutions).write("output/shipment-problem-with-solution.xml");
        SolutionPrinter.print((VehicleRoutingProblemSolution)bestSolution);
        Plotter problemPlotter = new Plotter(problem);
        problemPlotter.plotShipments(true);
        problemPlotter.plot("output/enRoutePickupAndDeliveryWithMultipleLocationsExample_problem.png", "en-route pickup and delivery");
        Plotter solutionPlotter = new Plotter(problem, Arrays.asList((VehicleRoute)Solutions.bestOf((Collection)solutions).getRoutes().iterator().next()));
        solutionPlotter.plotShipments(true);
        solutionPlotter.plot("output/enRoutePickupAndDeliveryWithMultipleLocationsExample_solution.png", "en-route pickup and delivery");
        new GraphStreamViewer(problem, Solutions.bestOf((Collection)solutions)).labelWith(GraphStreamViewer.Label.ACTIVITY).setRenderDelay(100L).setRenderShipments(true).display();
    }

    private static Location loc(Coordinate coordinate) {
        return Location.Builder.newInstance().setCoordinate(coordinate).build();
    }
}

