/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;

public class HVRPExample {
    public static void main(String[] args) {
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"1").addSizeDimension(0, 18).setLocation(Location.newInstance((double)22.0, (double)22.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"2").addSizeDimension(0, 26).setLocation(Location.newInstance((double)36.0, (double)26.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"3").addSizeDimension(0, 11).setLocation(Location.newInstance((double)21.0, (double)45.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"4").addSizeDimension(0, 30).setLocation(Location.newInstance((double)45.0, (double)35.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"5").addSizeDimension(0, 21).setLocation(Location.newInstance((double)55.0, (double)20.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"6").addSizeDimension(0, 19).setLocation(Location.newInstance((double)33.0, (double)34.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"7").addSizeDimension(0, 15).setLocation(Location.newInstance((double)50.0, (double)50.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"8").addSizeDimension(0, 16).setLocation(Location.newInstance((double)55.0, (double)45.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"9").addSizeDimension(0, 29).setLocation(Location.newInstance((double)26.0, (double)59.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"10").addSizeDimension(0, 26).setLocation(Location.newInstance((double)40.0, (double)66.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"11").addSizeDimension(0, 37).setLocation(Location.newInstance((double)55.0, (double)56.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"12").addSizeDimension(0, 16).setLocation(Location.newInstance((double)35.0, (double)51.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"13").addSizeDimension(0, 12).setLocation(Location.newInstance((double)62.0, (double)35.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"14").addSizeDimension(0, 31).setLocation(Location.newInstance((double)62.0, (double)57.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"15").addSizeDimension(0, 8).setLocation(Location.newInstance((double)62.0, (double)24.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"16").addSizeDimension(0, 19).setLocation(Location.newInstance((double)21.0, (double)36.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"17").addSizeDimension(0, 20).setLocation(Location.newInstance((double)33.0, (double)44.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"18").addSizeDimension(0, 13).setLocation(Location.newInstance((double)9.0, (double)56.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"19").addSizeDimension(0, 15).setLocation(Location.newInstance((double)62.0, (double)48.0)).build());
        vrpBuilder.addJob((AbstractJob)Service.Builder.newInstance((String)"20").addSizeDimension(0, 22).setLocation(Location.newInstance((double)66.0, (double)14.0)).build());
        VehicleTypeImpl type1 = VehicleTypeImpl.Builder.newInstance((String)"type_1").addCapacityDimension(0, 120).setCostPerDistance(1.0).build();
        VehicleImpl vehicle1_1 = VehicleImpl.Builder.newInstance((String)"1_1").setStartLocation(Location.newInstance((double)40.0, (double)40.0)).setType((VehicleType)type1).build();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle1_1);
        VehicleImpl vehicle1_2 = VehicleImpl.Builder.newInstance((String)"1_2").setStartLocation(Location.newInstance((double)40.0, (double)40.0)).setType((VehicleType)type1).build();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle1_2);
        VehicleTypeImpl type2 = VehicleTypeImpl.Builder.newInstance((String)"type_2").addCapacityDimension(0, 160).setCostPerDistance(1.1).build();
        VehicleImpl vehicle2_1 = VehicleImpl.Builder.newInstance((String)"2_1").setStartLocation(Location.newInstance((double)40.0, (double)40.0)).setType((VehicleType)type2).build();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle2_1);
        VehicleTypeImpl type3 = VehicleTypeImpl.Builder.newInstance((String)"type_3").addCapacityDimension(0, 300).setCostPerDistance(1.3).build();
        VehicleImpl vehicle3_1 = VehicleImpl.Builder.newInstance((String)"3_1").setStartLocation(Location.newInstance((double)40.0, (double)40.0)).setType((VehicleType)type3).build();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle3_1);
        vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        VehicleRoutingProblem vrp = vrpBuilder.build();
        VehicleRoutingAlgorithm vra = Jsprit.createAlgorithm((VehicleRoutingProblem)vrp);
        Collection solutions = vra.searchSolutions();
        VehicleRoutingProblemSolution best = Solutions.bestOf((Collection)solutions);
        SolutionPrinter.print((VehicleRoutingProblem)vrp, (VehicleRoutingProblemSolution)best, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new GraphStreamViewer(vrp, best).setRenderDelay(100L).display();
    }
}

