/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.state.StateId;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;

public class JobAndActivityDependenciesExample {
    public static void main(String[] args) {
        VehicleImpl driver1 = VehicleImpl.Builder.newInstance((String)"driver1").addSkill("driver1").setStartLocation(Location.newInstance((double)0.0, (double)0.0)).setReturnToDepot(false).build();
        VehicleImpl driver3 = VehicleImpl.Builder.newInstance((String)"driver3").addSkill("driver3").setStartLocation(Location.newInstance((double)-3.0, (double)5.0)).setReturnToDepot(true).build();
        Service s1 = Service.Builder.newInstance((String)"s1").addRequiredSkill("driver1").setName("install new device").setLocation(Location.newInstance((double)2.0, (double)2.0)).build();
        Service s2 = Service.Builder.newInstance((String)"s2").addRequiredSkill("driver3").setName("deliver key").setLocation(Location.newInstance((double)2.0, (double)4.0)).build();
        Service s3 = Service.Builder.newInstance((String)"s3").addRequiredSkill("driver1").setName("repair heater").setLocation(Location.newInstance((double)-2.0, (double)2.0)).build();
        Service s4 = Service.Builder.newInstance((String)"s4").addRequiredSkill("driver3").setName("get key").setLocation(Location.newInstance((double)-2.3, (double)4.0)).build();
        Service s5 = Service.Builder.newInstance((String)"s5").addRequiredSkill("driver1").setName("cleaning").setLocation(Location.newInstance((double)1.0, (double)5.0)).build();
        Service s6 = Service.Builder.newInstance((String)"s6").addRequiredSkill("driver3").setName("use key").setLocation(Location.newInstance((double)-2.0, (double)3.0)).build();
        Service s7 = Service.Builder.newInstance((String)"s7").addRequiredSkill("driver3").setName("maintenance").setLocation(Location.newInstance((double)-1.7, (double)3.5)).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance().setFleetSize(VehicleRoutingProblem.FleetSize.FINITE).addJob((AbstractJob)s1).addJob((AbstractJob)s2).addJob((AbstractJob)s3).addJob((AbstractJob)s4).addJob((AbstractJob)s5).addJob((AbstractJob)s6).addJob((AbstractJob)s7).addVehicle((AbstractVehicle)driver1).addVehicle((AbstractVehicle)driver3);
        VehicleRoutingProblem vrp = vrpBuilder.build();
        StateManager stateManager = new StateManager(vrp);
        StateId keyPicked = stateManager.createStateId("key-picked");
        StateId keyUsed = stateManager.createStateId("key-used");
        StateId keyDelivered = stateManager.createStateId("key-delivered");
        stateManager.addStateUpdater((StateUpdater)new KeyStatusUpdater(stateManager, keyPicked, keyUsed, keyDelivered));
        ConstraintManager constraintManager = new ConstraintManager(vrp, (RouteAndActivityStateGetter)stateManager);
        constraintManager.addConstraint((HardActivityConstraint)new GetUseAndDeliverKeySimpleHardActivityConstraint(stateManager, keyPicked, keyUsed, keyDelivered), ConstraintManager.Priority.CRITICAL);
        constraintManager.addConstraint((HardRouteConstraint)new GetUseAndDeliverHardRouteContraint(stateManager, keyPicked, keyUsed, keyDelivered));
        VehicleRoutingAlgorithm vra = Jsprit.Builder.newInstance((VehicleRoutingProblem)vrp).setStateAndConstraintManager(stateManager, constraintManager).buildAlgorithm();
        vra.setMaxIterations(100);
        Collection solutions = vra.searchSolutions();
        SolutionPrinter.print((VehicleRoutingProblem)vrp, (VehicleRoutingProblemSolution)Solutions.bestOf((Collection)solutions), (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new GraphStreamViewer(vrp, Solutions.bestOf((Collection)solutions)).labelWith(GraphStreamViewer.Label.JOB_NAME).display();
    }

    static class GetUseAndDeliverKeySimpleHardActivityConstraint
    implements HardActivityConstraint {
        StateManager stateManager;
        StateId keyPickedStateId;
        StateId keyUsedStateId;
        StateId keyDeliveredStateId;

        GetUseAndDeliverKeySimpleHardActivityConstraint(StateManager stateManager, StateId keyPickedStateId, StateId keyUsedStateId, StateId keyDeliveredStateId) {
            this.stateManager = stateManager;
            this.keyPickedStateId = keyPickedStateId;
            this.keyUsedStateId = keyUsedStateId;
            this.keyDeliveredStateId = keyDeliveredStateId;
        }

        public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
            VehicleRoute routeOfPickupKey = (VehicleRoute)this.stateManager.getProblemState(this.keyPickedStateId, VehicleRoute.class);
            VehicleRoute routeOfUseKey = (VehicleRoute)this.stateManager.getProblemState(this.keyUsedStateId, VehicleRoute.class);
            VehicleRoute routeOfDeliverKey = (VehicleRoute)this.stateManager.getProblemState(this.keyDeliveredStateId, VehicleRoute.class);
            if (!(this.isPickupKey(newAct) || this.isUseKey(newAct) || this.isDeliverKey(newAct))) {
                if (this.isPickupKey(prevAct) && this.isUseKey(nextAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
                }
                if (this.isPickupKey(prevAct) && this.isDeliverKey(nextAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
                }
                if (this.isUseKey(prevAct) && this.isDeliverKey(nextAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
                }
            }
            if (this.isPickupKey(newAct)) {
                if (routeOfUseKey != null && !this.isUseKey(nextAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
                }
                if (routeOfDeliverKey != null && !this.isDeliverKey(nextAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
                }
                return HardActivityConstraint.ConstraintsStatus.FULFILLED;
            }
            if (this.isUseKey(newAct)) {
                if (routeOfPickupKey != null && !this.isPickupKey(prevAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
                }
                if (routeOfDeliverKey != null && !this.isDeliverKey(nextAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
                }
                return HardActivityConstraint.ConstraintsStatus.FULFILLED;
            }
            if (this.isDeliverKey(newAct) && routeOfUseKey != null && !this.isUseKey(prevAct)) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
            }
            return HardActivityConstraint.ConstraintsStatus.FULFILLED;
        }

        private boolean isPickupKey(TourActivity act) {
            if (!(act instanceof TourActivity.JobActivity)) {
                return false;
            }
            return ((TourActivity.JobActivity)act).getJob().getName().equals("get key");
        }

        private boolean isUseKey(TourActivity act) {
            if (!(act instanceof TourActivity.JobActivity)) {
                return false;
            }
            return ((TourActivity.JobActivity)act).getJob().getName().equals("use key");
        }

        private boolean isDeliverKey(TourActivity act) {
            if (!(act instanceof TourActivity.JobActivity)) {
                return false;
            }
            return ((TourActivity.JobActivity)act).getJob().getName().equals("deliver key");
        }
    }

    static class GetUseAndDeliverHardRouteContraint
    implements HardRouteConstraint {
        StateManager stateManager;
        StateId keyPickedStateId;
        StateId keyUsedStateId;
        StateId keyDeliveredStateId;

        public GetUseAndDeliverHardRouteContraint(StateManager stateManager, StateId keyPickedStateId, StateId keyUsedStateId, StateId keyDeliveredStateId) {
            this.stateManager = stateManager;
            this.keyPickedStateId = keyPickedStateId;
            this.keyUsedStateId = keyUsedStateId;
            this.keyDeliveredStateId = keyDeliveredStateId;
        }

        public boolean fulfilled(JobInsertionContext iFacts) {
            if (iFacts.getJob().getName().equals("get key") || iFacts.getJob().getName().equals("use key") || iFacts.getJob().getName().equals("deliver key")) {
                VehicleRoute routeOfPickupKey = (VehicleRoute)this.stateManager.getProblemState(this.keyPickedStateId, VehicleRoute.class);
                VehicleRoute routeOfUseKey = (VehicleRoute)this.stateManager.getProblemState(this.keyUsedStateId, VehicleRoute.class);
                VehicleRoute routeOfDeliverKey = (VehicleRoute)this.stateManager.getProblemState(this.keyDeliveredStateId, VehicleRoute.class);
                if (routeOfPickupKey != null && routeOfPickupKey != iFacts.getRoute()) {
                    return false;
                }
                if (routeOfUseKey != null && routeOfUseKey != iFacts.getRoute()) {
                    return false;
                }
                if (routeOfDeliverKey != null && routeOfDeliverKey != iFacts.getRoute()) {
                    return false;
                }
            }
            return true;
        }
    }

    static class KeyStatusUpdater
    implements StateUpdater,
    ActivityVisitor {
        StateManager stateManager;
        StateId keyPickedStateId;
        StateId keyUsedStateId;
        private StateId keyDeliveredStateId;
        private VehicleRoute route;

        KeyStatusUpdater(StateManager stateManager, StateId keyPickedStateId, StateId keyUsedStateId, StateId keyDeliveredStateId) {
            this.stateManager = stateManager;
            this.keyPickedStateId = keyPickedStateId;
            this.keyUsedStateId = keyUsedStateId;
            this.keyDeliveredStateId = keyDeliveredStateId;
        }

        public void begin(VehicleRoute route) {
            this.route = route;
        }

        public void visit(TourActivity activity) {
            if (((TourActivity.JobActivity)activity).getJob().getName().equals("use key")) {
                this.stateManager.putProblemState(this.keyUsedStateId, VehicleRoute.class, (Object)this.route);
            } else if (((TourActivity.JobActivity)activity).getJob().getName().equals("get key")) {
                this.stateManager.putProblemState(this.keyPickedStateId, VehicleRoute.class, (Object)this.route);
            } else if (((TourActivity.JobActivity)activity).getJob().getName().equals("deliver key")) {
                this.stateManager.putProblemState(this.keyDeliveredStateId, VehicleRoute.class, (Object)this.route);
            }
        }

        public void finish() {
        }
    }
}

