/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.AlgorithmSearchProgressChartListener;
import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.analysis.toolbox.StopWatch;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListeners;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.io.problem.VrpXMLReader;
import com.graphhopper.jsprit.util.Examples;
import java.util.Arrays;
import java.util.Collection;

public class MultipleDepotExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new VrpXMLReader(vrpBuilder).read("input/vrp_cordeau_01.xml");
        int nuOfVehicles = 4;
        int capacity = 80;
        Coordinate firstDepotCoord = Coordinate.newInstance((double)20.0, (double)20.0);
        Coordinate second = Coordinate.newInstance((double)30.0, (double)40.0);
        Coordinate third = Coordinate.newInstance((double)50.0, (double)30.0);
        Coordinate fourth = Coordinate.newInstance((double)60.0, (double)50.0);
        int depotCounter = 1;
        for (Coordinate depotCoord : Arrays.asList(firstDepotCoord, second, third, fourth)) {
            for (int i = 0; i < nuOfVehicles; ++i) {
                VehicleTypeImpl vehicleType = VehicleTypeImpl.Builder.newInstance((String)(depotCounter + "_type")).addCapacityDimension(0, capacity).setCostPerDistance(1.0).build();
                VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)(depotCounter + "_" + (i + 1) + "_vehicle")).setStartLocation(Location.newInstance((double)depotCoord.getX(), (double)depotCoord.getY())).setType((VehicleType)vehicleType).build();
                vrpBuilder.addVehicle((AbstractVehicle)vehicle);
            }
            ++depotCounter;
        }
        vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        VehicleRoutingProblem vrp = vrpBuilder.build();
        VehicleRoutingAlgorithm vra = Jsprit.Builder.newInstance((VehicleRoutingProblem)vrp).setProperty(Jsprit.Parameter.THREADS, "5").buildAlgorithm();
        vra.getAlgorithmListeners().addListener((VehicleRoutingAlgorithmListener)new StopWatch(), VehicleRoutingAlgorithmListeners.Priority.HIGH);
        vra.getAlgorithmListeners().addListener((VehicleRoutingAlgorithmListener)new AlgorithmSearchProgressChartListener("output/progress.png"));
        Collection solutions = vra.searchSolutions();
        SolutionPrinter.print((VehicleRoutingProblemSolution)Solutions.bestOf((Collection)solutions));
        new Plotter(vrp, Solutions.bestOf((Collection)solutions)).setLabel(Plotter.Label.ID).plot("output/p01_solution.png", "p01");
        new GraphStreamViewer(vrp, Solutions.bestOf((Collection)solutions)).setRenderDelay(100L).display();
    }
}

