/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.AlgorithmSearchProgressChartListener;
import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.analysis.toolbox.StopWatch;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListeners;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.instance.reader.CordeauReader;
import com.graphhopper.jsprit.util.Examples;
import java.util.Arrays;
import java.util.Collection;

public class MultipleDepotExample2 {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new CordeauReader(vrpBuilder).read("input/p08");
        int nuOfVehicles = 13;
        int capacity = 500;
        double maxDuration = 310.0;
        Coordinate firstDepotCoord = Coordinate.newInstance((double)-33.0, (double)33.0);
        Coordinate second = Coordinate.newInstance((double)33.0, (double)-33.0);
        int depotCounter = 1;
        for (Coordinate depotCoord : Arrays.asList(firstDepotCoord, second)) {
            for (int i = 0; i < nuOfVehicles; ++i) {
                VehicleTypeImpl vehicleType = VehicleTypeImpl.Builder.newInstance((String)(depotCounter + "_type")).addCapacityDimension(0, capacity).setCostPerDistance(1.0).build();
                String vehicleId = depotCounter + "_" + (i + 1) + "_vehicle";
                VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)vehicleId);
                vehicleBuilder.setStartLocation(Location.newInstance((double)depotCoord.getX(), (double)depotCoord.getY()));
                vehicleBuilder.setType((VehicleType)vehicleType);
                vehicleBuilder.setLatestArrival(maxDuration);
                VehicleImpl vehicle = vehicleBuilder.build();
                vrpBuilder.addVehicle((AbstractVehicle)vehicle);
            }
            ++depotCounter;
        }
        vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        VehicleRoutingProblem vrp = vrpBuilder.build();
        VehicleRoutingAlgorithm vra = Jsprit.Builder.newInstance((VehicleRoutingProblem)vrp).setProperty(Jsprit.Parameter.FAST_REGRET, "true").setProperty(Jsprit.Parameter.THREADS, "5").buildAlgorithm();
        vra.setMaxIterations(2000);
        vra.getAlgorithmListeners().addListener((VehicleRoutingAlgorithmListener)new StopWatch(), VehicleRoutingAlgorithmListeners.Priority.HIGH);
        vra.getAlgorithmListeners().addListener((VehicleRoutingAlgorithmListener)new AlgorithmSearchProgressChartListener("output/progress.png"));
        Collection solutions = vra.searchSolutions();
        SolutionPrinter.print((VehicleRoutingProblem)vrp, (VehicleRoutingProblemSolution)Solutions.bestOf((Collection)solutions), (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new Plotter(vrp, Solutions.bestOf((Collection)solutions)).plot("output/p08_solution.png", "p08");
        new GraphStreamViewer(vrp, Solutions.bestOf((Collection)solutions)).setRenderDelay(50L).display();
    }
}

