/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.io.problem.VrpXMLReader;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class MultipleDepotWithInitialRoutesExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new VrpXMLReader(vrpBuilder).read("input/cordeau01.xml");
        VehicleRoute initialRoute = VehicleRoute.Builder.newInstance((Vehicle)MultipleDepotWithInitialRoutesExample.getVehicle("1_4_vehicle", vrpBuilder)).addService(MultipleDepotWithInitialRoutesExample.getService("44", vrpBuilder)).addService(MultipleDepotWithInitialRoutesExample.getService("26", vrpBuilder)).build();
        vrpBuilder.addInitialVehicleRoute(initialRoute);
        VehicleRoutingProblem vrp = vrpBuilder.build();
        assert (!vrp.getJobs().containsKey("26")) : "strange. service 26 should not be part of the problem";
        assert (!vrp.getJobs().containsKey("44")) : "strange. service 44 should not be part of the problem";
        new Plotter(vrp).setLabel(Plotter.Label.ID).plot("output/cordeau01_problem_withInitialRoute.png", "c");
        VehicleRoutingAlgorithm vra = Jsprit.createAlgorithm((VehicleRoutingProblem)vrp);
        Collection solutions = vra.searchSolutions();
        SolutionPrinter.print((VehicleRoutingProblemSolution)Solutions.bestOf((Collection)solutions));
        new Plotter(vrp, Solutions.bestOf((Collection)solutions)).setLabel(Plotter.Label.ID).plot("output/cordeau01_solution_withInitialRoute.png", "p01");
    }

    private static Service getService(String serviceId, VehicleRoutingProblem.Builder vrpBuilder) {
        for (Job j : vrpBuilder.getAddedJobs()) {
            if (!j.getId().equals(serviceId)) continue;
            return (Service)j;
        }
        return null;
    }

    private static Vehicle getVehicle(String vehicleId, VehicleRoutingProblem.Builder vrpBuilder) {
        for (Vehicle v : vrpBuilder.getAddedVehicles()) {
            if (!v.getId().equals(vehicleId)) continue;
            return v;
        }
        return null;
    }
}

