/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;

public class MultipleProductsWithLoadConstraintExample {
    static final int BANANAS_DIMENSION_INDEX = 0;
    static final int APPLES_DIMENSION_INDEX = 1;

    public static void main(String[] args) {
        VehicleTypeImpl type = VehicleTypeImpl.Builder.newInstance((String)"type").addCapacityDimension(0, 10).addCapacityDimension(1, 20).build();
        VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)"vehicle").setStartLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)0.0, (double)0.0))).setType((VehicleType)type).build();
        Shipment bananas = Shipment.Builder.newInstance((String)"bananas_1").addSizeDimension(0, 1).setPickupLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)1.0, (double)8.0))).setDeliveryLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)10.0, (double)8.0))).build();
        Shipment bananas_2 = Shipment.Builder.newInstance((String)"bananas_2").addSizeDimension(0, 1).setPickupLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)2.0, (double)8.0))).setDeliveryLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)11.0, (double)8.0))).build();
        Shipment bananas_3 = Shipment.Builder.newInstance((String)"bananas_3").addSizeDimension(0, 1).setPickupLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)3.0, (double)8.0))).setDeliveryLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)12.0, (double)8.0))).build();
        Shipment apples = Shipment.Builder.newInstance((String)"apples_1").addSizeDimension(1, 1).setPickupLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)1.0, (double)6.0))).setDeliveryLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)10.0, (double)12.0))).build();
        Shipment apples_2 = Shipment.Builder.newInstance((String)"apples_2").addSizeDimension(1, 1).setPickupLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)1.0, (double)5.0))).setDeliveryLocation(MultipleProductsWithLoadConstraintExample.loc(Coordinate.newInstance((double)10.0, (double)11.0))).build();
        VehicleRoutingProblem vrp = VehicleRoutingProblem.Builder.newInstance().setFleetSize(VehicleRoutingProblem.FleetSize.INFINITE).addVehicle((AbstractVehicle)vehicle).addJob((AbstractJob)bananas).addJob((AbstractJob)apples).addJob((AbstractJob)bananas_2).addJob((AbstractJob)bananas_3).addJob((AbstractJob)apples_2).build();
        StateManager stateManager = new StateManager(vrp);
        ConstraintManager constraintManager = new ConstraintManager(vrp, (RouteAndActivityStateGetter)stateManager);
        constraintManager.addConstraint((HardActivityConstraint)new NoBananasANDApplesConstraint(stateManager), ConstraintManager.Priority.CRITICAL);
        VehicleRoutingAlgorithm vra = Jsprit.Builder.newInstance((VehicleRoutingProblem)vrp).setStateAndConstraintManager(stateManager, constraintManager).buildAlgorithm();
        Collection solutions = vra.searchSolutions();
        SolutionPrinter.print((VehicleRoutingProblem)vrp, (VehicleRoutingProblemSolution)Solutions.bestOf((Collection)solutions), (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new GraphStreamViewer(vrp, Solutions.bestOf((Collection)solutions)).labelWith(GraphStreamViewer.Label.ID).setRenderShipments(true).display();
    }

    private static Location loc(Coordinate coordinate) {
        return Location.Builder.newInstance().setCoordinate(coordinate).build();
    }

    static class NoBananasANDApplesConstraint
    implements HardActivityConstraint {
        private StateManager stateManager;

        NoBananasANDApplesConstraint(StateManager stateManager) {
            this.stateManager = stateManager;
        }

        public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext jobInsertionContext, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double departureTimeAtPrevAct) {
            Capacity loadAtPrevAct = this.getLoadAtPreviousAct(prevAct);
            if (this.isPickup(newAct)) {
                if (this.isApplePickup(newAct) && this.hasBananasInVehicle(loadAtPrevAct) || this.isBananaPickup(newAct) && this.hasApplesInVehicle(loadAtPrevAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
                }
                if (this.isApplePickup(newAct) && this.isBananaPickup(nextAct) || this.isBananaPickup(newAct) && this.isApplePickup(nextAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
                }
                return HardActivityConstraint.ConstraintsStatus.FULFILLED;
            }
            if (this.isDelivery(newAct)) {
                if (this.isAppleDelivery(newAct) && this.hasBananasInVehicle(loadAtPrevAct) || this.isBananaDelivery(newAct) && this.hasApplesInVehicle(loadAtPrevAct)) {
                    return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
                }
                return HardActivityConstraint.ConstraintsStatus.FULFILLED;
            }
            throw new IllegalStateException("can only constraint shipments");
        }

        private boolean hasApplesInVehicle(Capacity loadAtPrevAct) {
            return loadAtPrevAct.get(1) > 0;
        }

        private boolean hasBananasInVehicle(Capacity loadAtPrevAct) {
            return loadAtPrevAct.get(0) > 0;
        }

        private boolean isBananaPickup(TourActivity act) {
            return act.getSize().get(0) > 0;
        }

        private boolean isBananaDelivery(TourActivity act) {
            return act.getSize().get(0) < 0;
        }

        private boolean isApplePickup(TourActivity act) {
            return act.getSize().get(1) > 0;
        }

        private boolean isAppleDelivery(TourActivity act) {
            return act.getSize().get(1) < 0;
        }

        private boolean isPickup(TourActivity newAct) {
            return newAct.getName().equals("pickupShipment");
        }

        private boolean isDelivery(TourActivity newAct) {
            return newAct.getName().equals("deliverShipment");
        }

        private Capacity getLoadAtPreviousAct(TourActivity prevAct) {
            Capacity prevLoad = (Capacity)this.stateManager.getActivityState(prevAct, InternalStates.LOAD, Capacity.class);
            if (prevLoad != null) {
                return prevLoad;
            }
            return Capacity.Builder.newInstance().build();
        }
    }

    static class BananasFirst
    implements HardActivityConstraint {
        BananasFirst() {
        }

        public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext jobInsertionContext, TourActivity prevActivity, TourActivity newActivity, TourActivity nextActivity, double departureTimeAtPrevActivity) {
            if (this.isBananaPickup(newActivity) && this.isApplePickup(prevActivity)) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
            }
            if (this.isBananaPickup(nextActivity) && this.isApplePickup(newActivity)) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
            }
            return HardActivityConstraint.ConstraintsStatus.FULFILLED;
        }

        private boolean isApplePickup(TourActivity act) {
            return act.getSize().get(1) > 0;
        }

        private boolean isBananaPickup(TourActivity act) {
            return act.getSize().get(0) > 0;
        }
    }
}

