/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.ManhattanCosts;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;

public class MultipleTimeWindowExample {
    public static void main(String[] args) {
        boolean WEIGHT_INDEX = false;
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 10).setCostPerWaitingTime(1.0);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)"vehicle");
        vehicleBuilder.setStartLocation(Location.newInstance((double)0.0, (double)0.0));
        vehicleBuilder.setType((VehicleType)vehicleType);
        VehicleImpl vehicle = vehicleBuilder.build();
        Service service1 = Service.Builder.newInstance((String)"1").addTimeWindow(50.0, 100.0).addTimeWindow(20.0, 35.0).addSizeDimension(0, 1).setLocation(Location.newInstance((double)10.0, (double)0.0)).build();
        Service service2 = Service.Builder.newInstance((String)"2").addSizeDimension(0, 1).setLocation(Location.newInstance((double)20.0, (double)0.0)).setServiceTime(10.0).build();
        Service service3 = Service.Builder.newInstance((String)"3").addTimeWindow(5.0, 10.0).addTimeWindow(35.0, 50.0).addSizeDimension(0, 1).setLocation(Location.newInstance((double)30.0, (double)0.0)).build();
        Service service4 = Service.Builder.newInstance((String)"4").addTimeWindow(20.0, 40.0).addTimeWindow(45.0, 80.0).addSizeDimension(0, 1).setLocation(Location.newInstance((double)40.0, (double)0.0)).build();
        Service service5 = Service.Builder.newInstance((String)"5").addTimeWindow(5.0, 10.0).addTimeWindow(20.0, 40.0).addTimeWindow(60.0, 100.0).addSizeDimension(0, 1).setLocation(Location.newInstance((double)20.0, (double)0.0)).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle);
        vrpBuilder.addJob((AbstractJob)service1).addJob((AbstractJob)service2).addJob((AbstractJob)service3).addJob((AbstractJob)service4).addJob((AbstractJob)service5);
        vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        vrpBuilder.setRoutingCost((VehicleRoutingTransportCosts)new ManhattanCosts());
        VehicleRoutingProblem problem = vrpBuilder.build();
        VehicleRoutingAlgorithm algorithm = Jsprit.createAlgorithm((VehicleRoutingProblem)problem);
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        SolutionPrinter.print((VehicleRoutingProblem)problem, (VehicleRoutingProblemSolution)bestSolution, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
    }
}

