/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.analysis.SolutionAnalyser;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.cost.TransportDistance;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;
import java.util.Random;

public class MultipleTimeWindowExample2 {
    public static void main(String[] args) {
        Service service;
        int i;
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 60).setCostPerWaitingTime(0.8);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)"vehicle");
        vehicleBuilder.setStartLocation(Location.newInstance((double)0.0, (double)0.0));
        vehicleBuilder.setType((VehicleType)vehicleType);
        vehicleBuilder.setLatestArrival(800.0);
        VehicleImpl vehicle = vehicleBuilder.build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle);
        vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        Random random = RandomNumberGeneration.newInstance();
        for (i = 0; i < 40; ++i) {
            service = Service.Builder.newInstance((String)("" + (i + 1))).addTimeWindow((double)random.nextInt(50), 200.0).addTimeWindow((double)(220 + random.nextInt(50)), 350.0).addTimeWindow((double)(400 + random.nextInt(50)), 550.0).setServiceTime(1.0).setLocation(Location.newInstance((double)random.nextInt(50), (double)random.nextInt(50))).build();
            vrpBuilder.addJob((AbstractJob)service);
        }
        for (i = 0; i < 12; ++i) {
            service = Service.Builder.newInstance((String)("" + (i + 51))).setServiceTime(2.0).setLocation(Location.newInstance((double)(50 + random.nextInt(20)), (double)(20 + random.nextInt(25)))).build();
            vrpBuilder.addJob((AbstractJob)service);
        }
        Service service2 = Service.Builder.newInstance((String)"100").addTimeWindow(50.0, 80.0).setServiceTime(10.0).setLocation(Location.newInstance((double)40.0, (double)1.0)).build();
        vrpBuilder.addJob((AbstractJob)service2);
        final VehicleRoutingProblem problem = vrpBuilder.build();
        VehicleRoutingAlgorithm algorithm = Jsprit.Builder.newInstance((VehicleRoutingProblem)problem).buildAlgorithm();
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        SolutionPrinter.print((VehicleRoutingProblem)problem, (VehicleRoutingProblemSolution)bestSolution, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new Plotter(problem, bestSolution).setLabel(Plotter.Label.ID).plot("output/plot", "mtw");
        SolutionAnalyser a = new SolutionAnalyser(problem, bestSolution, new TransportDistance(){

            public double getDistance(Location from, Location to, double departureTime, Vehicle vehicle) {
                return problem.getTransportCosts().getTransportTime(from, to, 0.0, null, null);
            }
        });
        System.out.println("distance: " + a.getDistance());
        System.out.println("ttime: " + a.getTransportTime());
        System.out.println("completion: " + a.getOperationTime());
        System.out.println("waiting: " + a.getWaitingTime());
    }
}

