/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.AlgorithmSearchProgressChartListener;
import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.selector.SelectBest;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.io.problem.VrpXMLReader;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class PickupAndDeliveryExample2 {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new VrpXMLReader(vrpBuilder).read("input/pd_christophides_vrpnc1_vcap50.xml");
        VehicleRoutingProblem vrp = vrpBuilder.build();
        new Plotter(vrp).plot("output/pd_christophides_vrpnc1.png", "pd_vrpnc1");
        VehicleRoutingAlgorithm vra = Jsprit.createAlgorithm((VehicleRoutingProblem)vrp);
        vra.getAlgorithmListeners().addListener((VehicleRoutingAlgorithmListener)new AlgorithmSearchProgressChartListener("output/sol_progress.png"));
        Collection solutions = vra.searchSolutions();
        VehicleRoutingProblemSolution solution = new SelectBest().selectSolution(solutions);
        SolutionPrinter.print((VehicleRoutingProblemSolution)solution);
        Plotter plotter = new Plotter(vrp, solution);
        plotter.setLabel(Plotter.Label.SIZE);
        plotter.plot("output/pd_christophides_vrpnc1_solution.png", "pd_vrpnc1");
        new GraphStreamViewer(vrp, solution).setRenderDelay(200L).display();
    }
}

