/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.GreedySchrimpfFactory;
import com.graphhopper.jsprit.core.algorithm.termination.IterationWithoutImprovementTermination;
import com.graphhopper.jsprit.core.algorithm.termination.PrematureAlgorithmTermination;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.core.util.VehicleRoutingTransportCostsMatrix;
import com.graphhopper.jsprit.io.problem.VrpXMLWriter;
import com.graphhopper.jsprit.util.Examples;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;

public class RefuseCollectionExample {
    public static void main(String[] args) throws IOException {
        Examples.createOutputFolder();
        VehicleTypeImpl.Builder typeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicle-type").addCapacityDimension(0, 23);
        typeBuilder.setCostPerDistance(1.0);
        VehicleTypeImpl bigType = typeBuilder.build();
        VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)"vehicle");
        vehicleBuilder.setStartLocation(Location.newInstance((String)"1"));
        vehicleBuilder.setType((VehicleType)bigType);
        VehicleImpl bigVehicle = vehicleBuilder.build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.INFINITE);
        vrpBuilder.addVehicle((AbstractVehicle)bigVehicle);
        RefuseCollectionExample.readDemandQuantities(vrpBuilder);
        VehicleRoutingTransportCostsMatrix.Builder matrixBuilder = VehicleRoutingTransportCostsMatrix.Builder.newInstance((boolean)true);
        RefuseCollectionExample.readDistances(matrixBuilder);
        vrpBuilder.setRoutingCost((VehicleRoutingTransportCosts)matrixBuilder.build());
        VehicleRoutingProblem vrp = vrpBuilder.build();
        VehicleRoutingAlgorithm vra = new GreedySchrimpfFactory().createAlgorithm(vrp);
        vra.setPrematureAlgorithmTermination((PrematureAlgorithmTermination)new IterationWithoutImprovementTermination(100));
        Collection solutions = vra.searchSolutions();
        SolutionPrinter.print((VehicleRoutingProblemSolution)Solutions.bestOf((Collection)solutions));
        new VrpXMLWriter(vrp, solutions).write("output/refuseCollectionExampleSolution.xml");
    }

    private static void readDemandQuantities(VehicleRoutingProblem.Builder vrpBuilder) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File("input/RefuseCollectionExample_Quantities")));
        boolean firstLine = true;
        while ((line = reader.readLine()) != null) {
            if (firstLine) {
                firstLine = false;
                continue;
            }
            String[] lineTokens = line.split(",");
            Service service = Service.Builder.newInstance((String)lineTokens[0]).addSizeDimension(0, Integer.parseInt(lineTokens[1])).setLocation(Location.newInstance((String)lineTokens[0])).build();
            vrpBuilder.addJob((AbstractJob)service);
        }
        reader.close();
    }

    private static void readDistances(VehicleRoutingTransportCostsMatrix.Builder matrixBuilder) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File("input/RefuseCollectionExample_Distances")));
        boolean firstLine = true;
        while ((line = reader.readLine()) != null) {
            if (firstLine) {
                firstLine = false;
                continue;
            }
            String[] lineTokens = line.split(",");
            matrixBuilder.addTransportDistance(lineTokens[0], lineTokens[1], (double)Integer.parseInt(lineTokens[2]));
        }
        reader.close();
    }
}

