/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.io.problem.VrpXMLWriter;
import com.graphhopper.jsprit.util.Examples;
import java.util.Arrays;
import java.util.Collection;

public class ServicePickupsWithMultipleDepotsExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 8);
        vehicleTypeBuilder.setCostPerDistance(1.0);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder1 = VehicleImpl.Builder.newInstance((String)"vehicles@[10,10]");
        vehicleBuilder1.setStartLocation(Location.newInstance((double)10.0, (double)10.0));
        vehicleBuilder1.setType((VehicleType)vehicleType);
        VehicleImpl vehicle1 = vehicleBuilder1.build();
        VehicleImpl.Builder vehicleBuilder2 = VehicleImpl.Builder.newInstance((String)"vehicles@[50,50]");
        vehicleBuilder2.setStartLocation(Location.newInstance((double)50.0, (double)50.0));
        vehicleBuilder2.setType((VehicleType)vehicleType);
        VehicleImpl vehicle2 = vehicleBuilder2.build();
        Service shipment1 = Service.Builder.newInstance((String)"1").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)7.0)).build();
        Service shipment2 = Service.Builder.newInstance((String)"2").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)13.0)).build();
        Service shipment3 = Service.Builder.newInstance((String)"3").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)7.0)).build();
        Service shipment4 = Service.Builder.newInstance((String)"4").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)13.0)).build();
        Service shipment5 = Service.Builder.newInstance((String)"5").addSizeDimension(0, 1).setLocation(Location.newInstance((double)55.0, (double)57.0)).build();
        Service shipment6 = Service.Builder.newInstance((String)"6").addSizeDimension(0, 1).setLocation(Location.newInstance((double)55.0, (double)63.0)).build();
        Service shipment7 = Service.Builder.newInstance((String)"7").addSizeDimension(0, 1).setLocation(Location.newInstance((double)65.0, (double)57.0)).build();
        Service shipment8 = Service.Builder.newInstance((String)"8").addSizeDimension(0, 1).setLocation(Location.newInstance((double)65.0, (double)63.0)).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle1).addVehicle((AbstractVehicle)vehicle2);
        vrpBuilder.addJob((AbstractJob)shipment1).addJob((AbstractJob)shipment2).addJob((AbstractJob)shipment3).addJob((AbstractJob)shipment4);
        vrpBuilder.addJob((AbstractJob)shipment5).addJob((AbstractJob)shipment6).addJob((AbstractJob)shipment7).addJob((AbstractJob)shipment8);
        VehicleRoutingProblem problem = vrpBuilder.build();
        VehicleRoutingAlgorithm algorithm = Jsprit.createAlgorithm((VehicleRoutingProblem)problem);
        algorithm.setMaxIterations(10);
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        new VrpXMLWriter(problem, solutions).write("output/shipment-problem-with-solution.xml");
        SolutionPrinter.print((VehicleRoutingProblemSolution)bestSolution);
        Plotter problemPlotter = new Plotter(problem);
        problemPlotter.plotShipments(true);
        problemPlotter.plot("output/enRoutePickupAndDeliveryWithMultipleLocationsExample_problem.png", "en-route pickup and delivery");
        Plotter solutionPlotter = new Plotter(problem, Arrays.asList((VehicleRoute)Solutions.bestOf((Collection)solutions).getRoutes().iterator().next()));
        solutionPlotter.plotShipments(true);
        solutionPlotter.plot("output/enRoutePickupAndDeliveryWithMultipleLocationsExample_solution.png", "en-route pickup and delivery");
        new GraphStreamViewer(problem, Solutions.bestOf((Collection)solutions)).labelWith(GraphStreamViewer.Label.ACTIVITY).setRenderDelay(100L).setRenderShipments(true).display();
    }
}

