/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.SchrimpfFactory;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.job.Pickup;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.io.problem.VrpXMLWriter;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class SimpleDepotBoundedPickupAndDeliveryExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 2);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)"vehicle");
        vehicleBuilder.setStartLocation(Location.newInstance((double)10.0, (double)10.0));
        vehicleBuilder.setType((VehicleType)vehicleType);
        VehicleImpl vehicle = vehicleBuilder.build();
        Pickup pickup1 = (Pickup)Pickup.Builder.newInstance((String)"1").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)7.0)).build();
        Delivery delivery1 = (Delivery)Delivery.Builder.newInstance((String)"2").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)13.0)).build();
        Pickup pickup2 = (Pickup)Pickup.Builder.newInstance((String)"3").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)7.0)).build();
        Delivery delivery2 = (Delivery)Delivery.Builder.newInstance((String)"4").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)13.0)).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle);
        vrpBuilder.addJob((AbstractJob)pickup1).addJob((AbstractJob)pickup2).addJob((AbstractJob)delivery1).addJob((AbstractJob)delivery2);
        VehicleRoutingProblem problem = vrpBuilder.build();
        VehicleRoutingAlgorithm algorithm = new SchrimpfFactory().createAlgorithm(problem);
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        new VrpXMLWriter(problem, solutions).write("output/problem-with-solution.xml");
        SolutionPrinter.print((VehicleRoutingProblemSolution)bestSolution);
        Plotter plotter = new Plotter(problem, bestSolution);
        plotter.setLabel(Plotter.Label.SIZE);
        plotter.plot("output/solution.png", "solution");
    }
}

