/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.SchrimpfFactory;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.io.problem.VrpXMLWriter;
import com.graphhopper.jsprit.util.Examples;
import java.util.Arrays;
import java.util.Collection;

public class SimpleEnRoutePickupAndDeliveryExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 2);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)"vehicle");
        vehicleBuilder.setStartLocation(SimpleEnRoutePickupAndDeliveryExample.loc(Coordinate.newInstance((double)10.0, (double)10.0)));
        vehicleBuilder.setType((VehicleType)vehicleType);
        VehicleImpl vehicle = vehicleBuilder.build();
        Shipment shipment1 = Shipment.Builder.newInstance((String)"1").addSizeDimension(0, 1).setPickupLocation(SimpleEnRoutePickupAndDeliveryExample.loc(Coordinate.newInstance((double)5.0, (double)7.0))).setDeliveryLocation(SimpleEnRoutePickupAndDeliveryExample.loc(Coordinate.newInstance((double)6.0, (double)9.0))).build();
        Shipment shipment2 = Shipment.Builder.newInstance((String)"2").addSizeDimension(0, 1).setPickupLocation(SimpleEnRoutePickupAndDeliveryExample.loc(Coordinate.newInstance((double)5.0, (double)13.0))).setDeliveryLocation(SimpleEnRoutePickupAndDeliveryExample.loc(Coordinate.newInstance((double)6.0, (double)11.0))).build();
        Shipment shipment3 = Shipment.Builder.newInstance((String)"3").addSizeDimension(0, 1).setPickupLocation(SimpleEnRoutePickupAndDeliveryExample.loc(Coordinate.newInstance((double)15.0, (double)7.0))).setDeliveryLocation(SimpleEnRoutePickupAndDeliveryExample.loc(Coordinate.newInstance((double)14.0, (double)9.0))).build();
        Shipment shipment4 = Shipment.Builder.newInstance((String)"4").addSizeDimension(0, 1).setPickupLocation(SimpleEnRoutePickupAndDeliveryExample.loc(Coordinate.newInstance((double)15.0, (double)13.0))).setDeliveryLocation(SimpleEnRoutePickupAndDeliveryExample.loc(Coordinate.newInstance((double)14.0, (double)11.0))).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle);
        vrpBuilder.addJob((AbstractJob)shipment1).addJob((AbstractJob)shipment2).addJob((AbstractJob)shipment3).addJob((AbstractJob)shipment4);
        VehicleRoutingProblem problem = vrpBuilder.build();
        VehicleRoutingAlgorithm algorithm = new SchrimpfFactory().createAlgorithm(problem);
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        new VrpXMLWriter(problem, solutions).write("output/shipment-problem-with-solution.xml");
        SolutionPrinter.print((VehicleRoutingProblemSolution)bestSolution);
        Plotter problemPlotter = new Plotter(problem);
        problemPlotter.plotShipments(true);
        problemPlotter.plot("output/simpleEnRoutePickupAndDeliveryExample_problem.png", "en-route pickup and delivery");
        Plotter solutionPlotter = new Plotter(problem, Arrays.asList((VehicleRoute)Solutions.bestOf((Collection)solutions).getRoutes().iterator().next()));
        solutionPlotter.plotShipments(true);
        solutionPlotter.plot("output/simpleEnRoutePickupAndDeliveryExample_solution.png", "en-route pickup and delivery");
        new GraphStreamViewer(problem).setRenderShipments(true).display();
    }

    private static Location loc(Coordinate coordinate) {
        return Location.Builder.newInstance().setCoordinate(coordinate).build();
    }
}

