/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.ServiceDeliveriesFirstConstraint;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.io.problem.VrpXMLWriter;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 2);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)"vehicle");
        vehicleBuilder.setStartLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)10.0, (double)10.0)));
        vehicleBuilder.setType((VehicleType)vehicleType);
        VehicleImpl vehicle = vehicleBuilder.build();
        Shipment shipment1 = Shipment.Builder.newInstance((String)"1").addSizeDimension(0, 1).setPickupLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)5.0, (double)7.0))).setDeliveryLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)6.0, (double)9.0))).build();
        Shipment shipment2 = Shipment.Builder.newInstance((String)"2").addSizeDimension(0, 1).setPickupLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)5.0, (double)13.0))).setDeliveryLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)6.0, (double)11.0))).build();
        Shipment shipment3 = Shipment.Builder.newInstance((String)"3").addSizeDimension(0, 1).setPickupLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)15.0, (double)7.0))).setDeliveryLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)14.0, (double)9.0))).build();
        Shipment shipment4 = Shipment.Builder.newInstance((String)"4").addSizeDimension(0, 1).setPickupLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)15.0, (double)13.0))).setDeliveryLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)14.0, (double)11.0))).build();
        Delivery delivery1 = (Delivery)Delivery.Builder.newInstance((String)"5").addSizeDimension(0, 1).setLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)4.0, (double)8.0))).build();
        Delivery delivery2 = (Delivery)Delivery.Builder.newInstance((String)"6").addSizeDimension(0, 1).setLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)4.0, (double)12.0))).build();
        Delivery delivery3 = (Delivery)Delivery.Builder.newInstance((String)"7").addSizeDimension(0, 1).setLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)16.0, (double)8.0))).build();
        Delivery delivery4 = (Delivery)Delivery.Builder.newInstance((String)"8").addSizeDimension(0, 1).setLocation(SimpleEnRoutePickupAndDeliveryWithDepotBoundedDeliveriesExample.loc(Coordinate.newInstance((double)16.0, (double)12.0))).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle);
        vrpBuilder.addJob((AbstractJob)shipment1).addJob((AbstractJob)shipment2).addJob((AbstractJob)shipment3).addJob((AbstractJob)shipment4).addJob((AbstractJob)delivery1).addJob((AbstractJob)delivery2).addJob((AbstractJob)delivery3).addJob((AbstractJob)delivery4).build();
        VehicleRoutingProblem problem = vrpBuilder.build();
        StateManager stateManager = new StateManager(problem);
        ConstraintManager constraintManager = new ConstraintManager(problem, (RouteAndActivityStateGetter)stateManager);
        constraintManager.addConstraint((HardActivityConstraint)new ServiceDeliveriesFirstConstraint(), ConstraintManager.Priority.CRITICAL);
        VehicleRoutingAlgorithm algorithm = Jsprit.Builder.newInstance((VehicleRoutingProblem)problem).setStateAndConstraintManager(stateManager, constraintManager).buildAlgorithm();
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        new VrpXMLWriter(problem, solutions).write("output/mixed-shipments-services-problem-with-solution.xml");
        SolutionPrinter.print((VehicleRoutingProblemSolution)bestSolution);
        Plotter problemPlotter = new Plotter(problem);
        problemPlotter.plotShipments(true);
        problemPlotter.plot("output/simpleMixedEnRoutePickupAndDeliveryExample_problem.png", "en-route pd and depot bounded deliveries");
        Plotter solutionPlotter = new Plotter(problem, Solutions.bestOf((Collection)solutions));
        solutionPlotter.plotShipments(true);
        solutionPlotter.plot("output/simpleMixedEnRoutePickupAndDeliveryExample_solution.png", "en-route pd and depot bounded deliveries");
    }

    private static Location loc(Coordinate coordinate) {
        return Location.Builder.newInstance().setCoordinate(coordinate).build();
    }
}

