/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.io.problem.VrpXMLWriter;
import java.io.File;
import java.util.Collection;

public class SimpleExample {
    public static void main(String[] args) {
        File dir = new File("output");
        if (!dir.exists()) {
            System.out.println("creating directory ./output");
            boolean result = dir.mkdir();
            if (result) {
                System.out.println("./output created");
            }
        }
        boolean WEIGHT_INDEX = false;
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 2);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)"vehicle");
        vehicleBuilder.setStartLocation(Location.newInstance((double)10.0, (double)10.0));
        vehicleBuilder.setType((VehicleType)vehicleType);
        VehicleImpl vehicle = vehicleBuilder.build();
        Service service1 = Service.Builder.newInstance((String)"1").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)7.0)).build();
        Service service2 = Service.Builder.newInstance((String)"2").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)13.0)).build();
        Service service3 = Service.Builder.newInstance((String)"3").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)7.0)).build();
        Service service4 = Service.Builder.newInstance((String)"4").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)13.0)).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle);
        vrpBuilder.addJob((AbstractJob)service1).addJob((AbstractJob)service2).addJob((AbstractJob)service3).addJob((AbstractJob)service4);
        VehicleRoutingProblem problem = vrpBuilder.build();
        VehicleRoutingAlgorithm algorithm = Jsprit.createAlgorithm((VehicleRoutingProblem)problem);
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        new VrpXMLWriter(problem, solutions).write("output/problem-with-solution.xml");
        SolutionPrinter.print((VehicleRoutingProblem)problem, (VehicleRoutingProblemSolution)bestSolution, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new Plotter(problem, bestSolution).plot("output/plot.png", "simple example");
        new GraphStreamViewer(problem, bestSolution).labelWith(GraphStreamViewer.Label.ID).setRenderDelay(200L).display();
    }
}

