/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.io.problem.VrpXMLWriter;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class SimpleExampleOpenRoutes {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleTypeImpl.Builder vehicleTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"vehicleType").addCapacityDimension(0, 2);
        vehicleTypeBuilder.setFixedCost(100.0);
        VehicleTypeImpl vehicleType = vehicleTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder = VehicleImpl.Builder.newInstance((String)"vehicle");
        vehicleBuilder.setStartLocation(Location.newInstance((double)10.0, (double)10.0));
        vehicleBuilder.setType((VehicleType)vehicleType);
        vehicleBuilder.setReturnToDepot(false);
        VehicleImpl vehicle = vehicleBuilder.build();
        Service service1 = Service.Builder.newInstance((String)"1").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)7.0)).build();
        Service service2 = Service.Builder.newInstance((String)"2").addSizeDimension(0, 1).setLocation(Location.newInstance((double)5.0, (double)13.0)).build();
        Service service3 = Service.Builder.newInstance((String)"3").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)7.0)).build();
        Service service4 = Service.Builder.newInstance((String)"4").addSizeDimension(0, 1).setLocation(Location.newInstance((double)15.0, (double)13.0)).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle);
        vrpBuilder.addJob((AbstractJob)service1).addJob((AbstractJob)service2).addJob((AbstractJob)service3).addJob((AbstractJob)service4);
        VehicleRoutingProblem problem = vrpBuilder.build();
        VehicleRoutingAlgorithm algorithm = Jsprit.createAlgorithm((VehicleRoutingProblem)problem);
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        new VrpXMLWriter(problem, solutions).write("output/problem-with-solution.xml");
        SolutionPrinter.print((VehicleRoutingProblemSolution)bestSolution);
        new Plotter(problem, bestSolution).plot("output/solution.png", "solution");
    }
}

