/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.SchrimpfFactory;
import com.graphhopper.jsprit.core.algorithm.selector.SelectBest;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.instance.reader.SolomonReader;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class SolomonExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new SolomonReader(vrpBuilder).read("input/C101_solomon.txt");
        VehicleRoutingProblem vrp = vrpBuilder.build();
        new Plotter(vrp).plot("output/solomon_C101.png", "C101");
        VehicleRoutingAlgorithm vra = new SchrimpfFactory().createAlgorithm(vrp);
        Collection solutions = vra.searchSolutions();
        VehicleRoutingProblemSolution solution = new SelectBest().selectSolution(solutions);
        SolutionPrinter.print((VehicleRoutingProblem)vrp, (VehicleRoutingProblemSolution)solution, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        Plotter plotter = new Plotter(vrp, solution);
        plotter.plot("output/solomon_C101_solution.png", "C101");
        new GraphStreamViewer(vrp, solution).setCameraView(30.0, 30.0, 0.25).labelWith(GraphStreamViewer.Label.ID).setRenderDelay(100L).display();
    }
}

