/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.AlgorithmEventsRecorder;
import com.graphhopper.jsprit.analysis.toolbox.AlgorithmEventsViewer;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.selector.SelectBest;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.io.problem.VrpXMLReader;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class SolomonOpenExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new VrpXMLReader(vrpBuilder).read("input/deliveries_solomon_open_c101.xml");
        VehicleRoutingProblem vrp = vrpBuilder.build();
        AlgorithmEventsRecorder eventsRecorder = new AlgorithmEventsRecorder(vrp, "output/events.dgs.gz");
        eventsRecorder.setRecordingRange(0, 50);
        VehicleRoutingAlgorithm vra = Jsprit.Builder.newInstance((VehicleRoutingProblem)vrp).setProperty(Jsprit.Parameter.THREADS, "4").setProperty(Jsprit.Parameter.FAST_REGRET, "true").setProperty(Jsprit.Parameter.CONSTRUCTION, Jsprit.Construction.BEST_INSERTION.toString()).buildAlgorithm();
        vra.addListener((VehicleRoutingAlgorithmListener)eventsRecorder);
        vra.setMaxIterations(200);
        Collection solutions = vra.searchSolutions();
        VehicleRoutingProblemSolution solution = new SelectBest().selectSolution(solutions);
        SolutionPrinter.print((VehicleRoutingProblemSolution)solution);
        AlgorithmEventsViewer viewer = new AlgorithmEventsViewer();
        viewer.setRuinDelay(8L);
        viewer.setRecreationDelay(2L);
        viewer.display("output/events.dgs.gz");
    }
}

