/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.instance.reader.SolomonReader;
import com.graphhopper.jsprit.io.problem.VrpXMLWriter;
import java.util.Collection;

public class SolomonWithSkillsExample {
    public static void main(String[] args) {
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new SolomonReader(vrpBuilder).read("input/C101_solomon.txt");
        VehicleRoutingProblem vrp = vrpBuilder.build();
        Vehicle solomonVehicle = (Vehicle)vrp.getVehicles().iterator().next();
        VehicleType newType = solomonVehicle.getType();
        VehicleRoutingProblem.Builder skillProblemBuilder = VehicleRoutingProblem.Builder.newInstance();
        for (int i = 0; i < 5; ++i) {
            VehicleImpl skill1Vehicle = VehicleImpl.Builder.newInstance((String)("skill1_vehicle_" + i)).addSkill("skill1").setStartLocation(Location.Builder.newInstance().setId(solomonVehicle.getStartLocation().getId()).setCoordinate(solomonVehicle.getStartLocation().getCoordinate()).build()).setEarliestStart(solomonVehicle.getEarliestDeparture()).setType(newType).build();
            VehicleImpl skill2Vehicle = VehicleImpl.Builder.newInstance((String)("skill2_vehicle_" + i)).addSkill("skill2").setStartLocation(Location.Builder.newInstance().setId(solomonVehicle.getStartLocation().getId()).setCoordinate(solomonVehicle.getStartLocation().getCoordinate()).build()).setEarliestStart(solomonVehicle.getEarliestDeparture()).setType(newType).build();
            skillProblemBuilder.addVehicle((AbstractVehicle)skill1Vehicle).addVehicle((AbstractVehicle)skill2Vehicle);
        }
        for (Job job : vrp.getJobs().values()) {
            Service.Builder skillServiceBuilder;
            Service service = (Service)job;
            if (service.getLocation().getCoordinate().getY() < 50.0) {
                skillServiceBuilder = Service.Builder.newInstance((String)(service.getId() + "_skill2")).setServiceTime(service.getServiceDuration()).setLocation(Location.Builder.newInstance().setId(service.getLocation().getId()).setCoordinate(service.getLocation().getCoordinate()).build()).setTimeWindow(service.getTimeWindow()).addSizeDimension(0, service.getSize().get(0));
                skillServiceBuilder.addRequiredSkill("skill2");
            } else {
                skillServiceBuilder = Service.Builder.newInstance((String)(service.getId() + "_skill1")).setServiceTime(service.getServiceDuration()).setLocation(Location.Builder.newInstance().setId(service.getLocation().getId()).setCoordinate(service.getLocation().getCoordinate()).build()).setTimeWindow(service.getTimeWindow()).addSizeDimension(0, service.getSize().get(0));
                skillServiceBuilder.addRequiredSkill("skill1");
            }
            skillProblemBuilder.addJob((AbstractJob)skillServiceBuilder.build());
        }
        skillProblemBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        VehicleRoutingProblem skillProblem = skillProblemBuilder.build();
        VehicleRoutingAlgorithm vra = Jsprit.Builder.newInstance((VehicleRoutingProblem)skillProblem).buildAlgorithm();
        Collection solutions = vra.searchSolutions();
        VehicleRoutingProblemSolution solution = Solutions.bestOf((Collection)solutions);
        SolutionPrinter.print((VehicleRoutingProblem)skillProblem, (VehicleRoutingProblemSolution)solution, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new Plotter(skillProblem, solution).plot("output/skill_solution", "solomon_with_skills");
        new VrpXMLWriter(skillProblem, solutions).write("output/solomon_with_skills");
    }
}

