/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.termination.IterationWithoutImprovementTermination;
import com.graphhopper.jsprit.core.algorithm.termination.PrematureAlgorithmTermination;
import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class TransportOfDisabledPeople {
    static int WHEELCHAIRSPACE_INDEX = 0;
    static int PASSENGERSEATS_INDEX = 1;

    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleTypeImpl.Builder wheelChairTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"wheelChairBusType").addCapacityDimension(WHEELCHAIRSPACE_INDEX, 2).addCapacityDimension(PASSENGERSEATS_INDEX, 4);
        VehicleTypeImpl vehicleType_wheelchair = wheelChairTypeBuilder.build();
        VehicleTypeImpl.Builder soleyPassengerTypeBuilder = VehicleTypeImpl.Builder.newInstance((String)"passengerBusType").addCapacityDimension(PASSENGERSEATS_INDEX, 6);
        VehicleTypeImpl vehicleType_solelypassenger = soleyPassengerTypeBuilder.build();
        VehicleImpl.Builder vehicleBuilder1 = VehicleImpl.Builder.newInstance((String)"wheelchair_bus");
        vehicleBuilder1.setStartLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)10.0, (double)10.0)));
        vehicleBuilder1.setType((VehicleType)vehicleType_wheelchair);
        VehicleImpl vehicle1 = vehicleBuilder1.build();
        VehicleImpl.Builder vehicleBuilder1_2 = VehicleImpl.Builder.newInstance((String)"wheelchair_bus_2");
        vehicleBuilder1_2.setStartLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)10.0, (double)10.0)));
        vehicleBuilder1_2.setType((VehicleType)vehicleType_wheelchair);
        VehicleImpl vehicle1_2 = vehicleBuilder1_2.build();
        VehicleImpl.Builder vehicleBuilder2 = VehicleImpl.Builder.newInstance((String)"passenger_bus");
        vehicleBuilder2.setStartLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)30.0, (double)30.0))).setEndLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)30.0, (double)19.0)));
        vehicleBuilder2.setType((VehicleType)vehicleType_solelypassenger);
        VehicleImpl vehicle2 = vehicleBuilder2.build();
        VehicleImpl.Builder vehicleBuilder2_2 = VehicleImpl.Builder.newInstance((String)"passenger_bus_2");
        vehicleBuilder2_2.setStartLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)30.0, (double)30.0))).setEndLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)30.0, (double)19.0)));
        vehicleBuilder2_2.setType((VehicleType)vehicleType_solelypassenger);
        VehicleImpl vehicle2_2 = vehicleBuilder2_2.build();
        Shipment shipment1 = Shipment.Builder.newInstance((String)"wheelchair_1").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)5.0, (double)7.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)6.0, (double)9.0))).build();
        Shipment shipment2 = Shipment.Builder.newInstance((String)"2").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)5.0, (double)13.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)6.0, (double)11.0))).build();
        Shipment shipment3 = Shipment.Builder.newInstance((String)"wheelchair_2").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)15.0, (double)7.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)14.0, (double)9.0))).build();
        Shipment shipment4 = Shipment.Builder.newInstance((String)"4").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)15.0, (double)13.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)14.0, (double)11.0))).build();
        Shipment shipment5 = Shipment.Builder.newInstance((String)"wheelchair_3").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)25.0, (double)27.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)26.0, (double)29.0))).build();
        Shipment shipment6 = Shipment.Builder.newInstance((String)"6").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)25.0, (double)33.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)26.0, (double)31.0))).build();
        Shipment shipment7 = Shipment.Builder.newInstance((String)"7").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)35.0, (double)27.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)34.0, (double)29.0))).build();
        Shipment shipment8 = Shipment.Builder.newInstance((String)"wheelchair_4").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)35.0, (double)33.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)34.0, (double)31.0))).build();
        Shipment shipment9 = Shipment.Builder.newInstance((String)"9").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)5.0, (double)27.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)6.0, (double)29.0))).build();
        Shipment shipment10 = Shipment.Builder.newInstance((String)"wheelchair_5").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)5.0, (double)33.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)6.0, (double)31.0))).build();
        Shipment shipment11 = Shipment.Builder.newInstance((String)"11").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)15.0, (double)27.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)14.0, (double)29.0))).build();
        Shipment shipment12 = Shipment.Builder.newInstance((String)"wheelchair_6").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)15.0, (double)33.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)14.0, (double)31.0))).build();
        Shipment shipment13 = Shipment.Builder.newInstance((String)"13").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)25.0, (double)7.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)26.0, (double)9.0))).build();
        Shipment shipment14 = Shipment.Builder.newInstance((String)"wheelchair_7").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)25.0, (double)13.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)26.0, (double)11.0))).build();
        Shipment shipment15 = Shipment.Builder.newInstance((String)"15").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)35.0, (double)7.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)34.0, (double)9.0))).build();
        Shipment shipment16 = Shipment.Builder.newInstance((String)"wheelchair_8").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)35.0, (double)13.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)34.0, (double)11.0))).build();
        Shipment shipment17 = Shipment.Builder.newInstance((String)"17").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)5.0, (double)14.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)6.0, (double)16.0))).build();
        Shipment shipment18 = Shipment.Builder.newInstance((String)"wheelchair_9").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)5.0, (double)20.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)6.0, (double)18.0))).build();
        Shipment shipment19 = Shipment.Builder.newInstance((String)"19").addSizeDimension(PASSENGERSEATS_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)15.0, (double)14.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)14.0, (double)16.0))).build();
        Shipment shipment20 = Shipment.Builder.newInstance((String)"wheelchair_10").addSizeDimension(WHEELCHAIRSPACE_INDEX, 1).setPickupLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)15.0, (double)20.0))).setDeliveryLocation(TransportOfDisabledPeople.loc(Coordinate.newInstance((double)14.0, (double)18.0))).build();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        vrpBuilder.addVehicle((AbstractVehicle)vehicle1).addVehicle((AbstractVehicle)vehicle2).addVehicle((AbstractVehicle)vehicle1_2).addVehicle((AbstractVehicle)vehicle2_2);
        vrpBuilder.addJob((AbstractJob)shipment1).addJob((AbstractJob)shipment2).addJob((AbstractJob)shipment3).addJob((AbstractJob)shipment4);
        vrpBuilder.addJob((AbstractJob)shipment5).addJob((AbstractJob)shipment6).addJob((AbstractJob)shipment7).addJob((AbstractJob)shipment8);
        vrpBuilder.addJob((AbstractJob)shipment9).addJob((AbstractJob)shipment10).addJob((AbstractJob)shipment11).addJob((AbstractJob)shipment12);
        vrpBuilder.addJob((AbstractJob)shipment13).addJob((AbstractJob)shipment14).addJob((AbstractJob)shipment15).addJob((AbstractJob)shipment16);
        vrpBuilder.addJob((AbstractJob)shipment17).addJob((AbstractJob)shipment18).addJob((AbstractJob)shipment19).addJob((AbstractJob)shipment20);
        vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        HardRouteConstraint wheelchair_bus_passenger_pickup_constraint = new HardRouteConstraint(){

            public boolean fulfilled(JobInsertionContext insertionContext) {
                Shipment shipment2insert = (Shipment)insertionContext.getJob();
                return !insertionContext.getNewVehicle().getId().equals("wheelchair_bus") || shipment2insert.getSize().get(PASSENGERSEATS_INDEX) <= 0 || !(shipment2insert.getPickupLocation().getCoordinate().getX() > 15.0) && !(shipment2insert.getDeliveryLocation().getCoordinate().getX() > 15.0);
            }
        };
        VehicleRoutingProblem problem = vrpBuilder.build();
        StateManager stateManager = new StateManager(problem);
        ConstraintManager constraintManager = new ConstraintManager(problem, (RouteAndActivityStateGetter)stateManager);
        constraintManager.addConstraint(wheelchair_bus_passenger_pickup_constraint);
        VehicleRoutingAlgorithm algorithm = Jsprit.Builder.newInstance((VehicleRoutingProblem)problem).setStateAndConstraintManager(stateManager, constraintManager).buildAlgorithm();
        algorithm.setPrematureAlgorithmTermination((PrematureAlgorithmTermination)new IterationWithoutImprovementTermination(100));
        Collection solutions = algorithm.searchSolutions();
        VehicleRoutingProblemSolution bestSolution = Solutions.bestOf((Collection)solutions);
        SolutionPrinter.print((VehicleRoutingProblem)problem, (VehicleRoutingProblemSolution)bestSolution, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        Plotter problemPlotter = new Plotter(problem);
        problemPlotter.plotShipments(true);
        problemPlotter.setLabel(Plotter.Label.SIZE);
        problemPlotter.plot("output/transportOfDisabledPeopleExample_problem.png", "disabled people tp");
        Plotter solutionPlotter = new Plotter(problem, Solutions.bestOf((Collection)solutions));
        solutionPlotter.plotShipments(true);
        solutionPlotter.setLabel(Plotter.Label.SIZE);
        solutionPlotter.plot("output/transportOfDisabledPeopleExample_solution.png", "disabled people tp");
        new GraphStreamViewer(problem).labelWith(GraphStreamViewer.Label.ID).setRenderDelay(100L).setRenderShipments(true).display();
        new GraphStreamViewer(problem, Solutions.bestOf((Collection)solutions)).labelWith(GraphStreamViewer.Label.ACTIVITY).setRenderDelay(100L).setRenderShipments(true).display();
    }

    private static Location loc(Coordinate coordinate) {
        return Location.Builder.newInstance().setCoordinate(coordinate).build();
    }
}

