/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.AlgorithmSearchProgressChartListener;
import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.selector.SelectBest;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.ServiceDeliveriesFirstConstraint;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.io.problem.VrpXMLReader;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class VRPWithBackhaulsExample {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new VrpXMLReader(vrpBuilder).read("input/pickups_and_deliveries_solomon_r101.xml");
        VehicleRoutingProblem vrp = vrpBuilder.build();
        StateManager stateManager = new StateManager(vrp);
        ConstraintManager constraintManager = new ConstraintManager(vrp, (RouteAndActivityStateGetter)stateManager);
        constraintManager.addConstraint((HardActivityConstraint)new ServiceDeliveriesFirstConstraint(), ConstraintManager.Priority.CRITICAL);
        VehicleRoutingAlgorithm vra = Jsprit.Builder.newInstance((VehicleRoutingProblem)vrp).setStateAndConstraintManager(stateManager, constraintManager).buildAlgorithm();
        vra.getAlgorithmListeners().addListener((VehicleRoutingAlgorithmListener)new AlgorithmSearchProgressChartListener("output/sol_progress.png"));
        Collection solutions = vra.searchSolutions();
        VehicleRoutingProblemSolution solution = new SelectBest().selectSolution(solutions);
        SolutionPrinter.print((VehicleRoutingProblem)vrp, (VehicleRoutingProblemSolution)solution, (SolutionPrinter.Print)SolutionPrinter.Print.VERBOSE);
        new GraphStreamViewer(vrp, solution).setRenderDelay(100L).display();
    }
}

