/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.examples;

import com.graphhopper.jsprit.analysis.toolbox.AlgorithmSearchProgressChartListener;
import com.graphhopper.jsprit.analysis.toolbox.Plotter;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.selector.SelectBest;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.analysis.SolutionAnalyser;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.ServiceDeliveriesFirstConstraint;
import com.graphhopper.jsprit.core.problem.cost.TransportDistance;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.reporting.SolutionPrinter;
import com.graphhopper.jsprit.io.problem.VrpXMLReader;
import com.graphhopper.jsprit.util.Examples;
import java.util.Collection;

public class VRPWithBackhaulsExample2 {
    public static void main(String[] args) {
        Examples.createOutputFolder();
        VehicleRoutingProblem.Builder vrpBuilder = VehicleRoutingProblem.Builder.newInstance();
        new VrpXMLReader(vrpBuilder).read("input/pd_christophides_vrpnc1_vcap50.xml");
        final VehicleRoutingProblem vrp = vrpBuilder.build();
        StateManager stateManager = new StateManager(vrp);
        ConstraintManager constraintManager = new ConstraintManager(vrp, (RouteAndActivityStateGetter)stateManager);
        constraintManager.addConstraint((HardActivityConstraint)new ServiceDeliveriesFirstConstraint(), ConstraintManager.Priority.CRITICAL);
        VehicleRoutingAlgorithm vra = Jsprit.Builder.newInstance((VehicleRoutingProblem)vrp).setStateAndConstraintManager(stateManager, constraintManager).setProperty(Jsprit.Parameter.FIXED_COST_PARAM.toString(), "0.").buildAlgorithm();
        vra.setMaxIterations(2000);
        vra.addListener((VehicleRoutingAlgorithmListener)new AlgorithmSearchProgressChartListener("output/search"));
        Collection solutions = vra.searchSolutions();
        VehicleRoutingProblemSolution solution = new SelectBest().selectSolution(solutions);
        SolutionPrinter.print((VehicleRoutingProblemSolution)solution);
        Plotter plotter = new Plotter(vrp, solution);
        plotter.plot("output/vrpwbh_christophides_vrpnc1_solution.png", "vrpwbh_vrpnc1");
        SolutionAnalyser analyser = new SolutionAnalyser(vrp, solution, new TransportDistance(){

            public double getDistance(Location from, Location to, double departureTime, Vehicle vehicle) {
                return vrp.getTransportCosts().getTransportCost(from, to, 0.0, null, null);
            }
        });
        for (VehicleRoute route : solution.getRoutes()) {
            System.out.println("------");
            System.out.println("vehicleId: " + route.getVehicle().getId());
            System.out.println("vehicleCapacity: " + route.getVehicle().getType().getCapacityDimensions() + " maxLoad: " + analyser.getMaxLoad(route));
            System.out.println("totalDistance: " + analyser.getDistance(route));
            System.out.println("waitingTime: " + analyser.getWaitingTime(route));
            System.out.println("load@beginning: " + analyser.getLoadAtBeginning(route));
            System.out.println("load@end: " + analyser.getLoadAtEnd(route));
            System.out.println("operationTime: " + analyser.getOperationTime(route));
            System.out.println("serviceTime: " + analyser.getServiceTime(route));
            System.out.println("transportTime: " + analyser.getTransportTime(route));
            System.out.println("transportCosts: " + analyser.getVariableTransportCosts(route));
            System.out.println("fixedCosts: " + analyser.getFixedCosts(route));
            System.out.println("capViolationOnRoute: " + analyser.getCapacityViolation(route));
            System.out.println("capViolation@beginning: " + analyser.getCapacityViolationAtBeginning(route));
            System.out.println("capViolation@end: " + analyser.getCapacityViolationAtEnd(route));
            System.out.println("timeWindowViolationOnRoute: " + analyser.getTimeWindowViolation(route));
            System.out.println("skillConstraintViolatedOnRoute: " + analyser.hasSkillConstraintViolation(route));
            System.out.println("dist@" + route.getStart().getLocation().getId() + ": " + analyser.getDistanceAtActivity((TourActivity)route.getStart(), route));
            System.out.println("timeWindowViolation@" + route.getStart().getLocation().getId() + ": " + analyser.getTimeWindowViolationAtActivity((TourActivity)route.getStart(), route));
            for (TourActivity act : route.getActivities()) {
                System.out.println("--");
                System.out.println("actType: " + act.getName() + " demand: " + act.getSize());
                System.out.println("dist@" + act.getLocation().getId() + ": " + analyser.getDistanceAtActivity(act, route));
                System.out.println("load(before)@" + act.getLocation().getId() + ": " + analyser.getLoadJustBeforeActivity(act, route));
                System.out.println("load(after)@" + act.getLocation().getId() + ": " + analyser.getLoadRightAfterActivity(act, route));
                System.out.println("transportCosts@" + act.getLocation().getId() + ": " + analyser.getVariableTransportCostsAtActivity(act, route));
                System.out.println("capViolation(after)@" + act.getLocation().getId() + ": " + analyser.getCapacityViolationAfterActivity(act, route));
                System.out.println("timeWindowViolation@" + act.getLocation().getId() + ": " + analyser.getTimeWindowViolationAtActivity(act, route));
                System.out.println("skillConstraintViolated@" + act.getLocation().getId() + ": " + analyser.hasSkillConstraintViolationAtActivity(act, route));
            }
            System.out.println("--");
            System.out.println("dist@" + route.getEnd().getLocation().getId() + ": " + analyser.getDistanceAtActivity((TourActivity)route.getEnd(), route));
            System.out.println("timeWindowViolation@" + route.getEnd().getLocation().getId() + ": " + analyser.getTimeWindowViolationAtActivity((TourActivity)route.getEnd(), route));
        }
        System.out.println("-----");
        System.out.println("aggreate solution stats");
        System.out.println("total freight moved: " + Capacity.addup((Capacity)analyser.getLoadAtBeginning(), (Capacity)analyser.getLoadPickedUp()));
        System.out.println("total no. picks at beginning: " + analyser.getNumberOfPickupsAtBeginning());
        System.out.println("total no. picks on routes: " + analyser.getNumberOfPickups());
        System.out.println("total picked load at beginnnig: " + analyser.getLoadAtBeginning());
        System.out.println("total picked load on routes: " + analyser.getLoadPickedUp());
        System.out.println("total no. deliveries at end: " + analyser.getNumberOfDeliveriesAtEnd());
        System.out.println("total no. deliveries on routes: " + analyser.getNumberOfDeliveries());
        System.out.println("total delivered load at end: " + analyser.getLoadAtEnd());
        System.out.println("total delivered load on routes: " + analyser.getLoadDelivered());
        System.out.println("total tp_distance: " + analyser.getDistance());
        System.out.println("total tp_time: " + analyser.getTransportTime());
        System.out.println("total waiting_time: " + analyser.getWaitingTime());
        System.out.println("total service_time: " + analyser.getServiceTime());
        System.out.println("total operation_time: " + analyser.getOperationTime());
        System.out.println("total twViolation: " + analyser.getTimeWindowViolation());
        System.out.println("total capViolation: " + analyser.getCapacityViolation());
        System.out.println("total fixedCosts: " + analyser.getFixedCosts());
        System.out.println("total variableCosts: " + analyser.getVariableTransportCosts());
        System.out.println("total costs: " + analyser.getTotalCosts());
    }
}

