/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.viewer.domain;

import com.groupdocs.viewer.domain.DocumentType;
import com.groupdocs.viewer.domain.FileType;
import org.apache.commons.io.FilenameUtils;

public class GroupDocsFileDescription {
    private String guid;
    private String name;
    private long size;
    private long lastModified;

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getBaseName() {
        return FilenameUtils.getBaseName((String)this.name);
    }

    public FileType getFileType() {
        String string = FilenameUtils.getExtension((String)this.name);
        if (string != null && !string.isEmpty()) {
            FileType fileType = FileType.getValue(string);
            return fileType == null ? FileType.UNKNOWN : fileType;
        }
        return FileType.DIRECTORY;
    }

    public boolean isPdf() {
        FileType fileType = this.getFileType();
        return fileType != null ? fileType.equals((Object)FileType.PDF) || fileType.equals((Object)FileType.XPS) || fileType.equals((Object)FileType.EPUB) : false;
    }

    public boolean isImage() {
        FileType fileType = this.getFileType();
        return fileType != null ? DocumentType.getDocumentType(fileType).equals("Image") : false;
    }
}

