/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.viewer.handlers;

import com.groupdocs.viewer.b.d;
import com.groupdocs.viewer.c.b.b;
import com.groupdocs.viewer.config.ServiceConfiguration;
import com.groupdocs.viewer.d.a.a;
import com.groupdocs.viewer.d.f;
import com.groupdocs.viewer.domain.GroupDocsFileDescription;
import com.groupdocs.viewer.domain.request.DocumentPageRequest;
import com.groupdocs.viewer.domain.request.FileBrowserTreeDataRequest;
import com.groupdocs.viewer.domain.request.ImageUrlsRequest;
import com.groupdocs.viewer.domain.request.PrintableHtmlRequest;
import com.groupdocs.viewer.domain.request.ReorderPageRequest;
import com.groupdocs.viewer.domain.request.RotatePageRequest;
import com.groupdocs.viewer.domain.request.ViewDocumentRequest;
import com.groupdocs.viewer.domain.response.FileBrowserTreeDataResponse;
import com.groupdocs.viewer.domain.response.ImageUrlsResponse;
import com.groupdocs.viewer.domain.response.ReorderPageResponse;
import com.groupdocs.viewer.domain.response.RotatePageResponse;
import com.groupdocs.viewer.domain.response.ViewDocumentResponse;
import com.groupdocs.viewer.handlers.ViewerHandlerBasic;
import com.groupdocs.viewer.handlers.b.c;
import com.groupdocs.viewer.handlers.cache.CacheDataHandler;
import com.groupdocs.viewer.handlers.input.InputDataHandler;
import com.groupdocs.viewer.resources.IGroupDocsViewer;
import com.groupdocs.viewer.resources.IGroupDocsViewerIE;
import com.groupdocs.viewer.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class ViewerHandler
extends ViewerHandlerBasic
implements IGroupDocsViewer,
IGroupDocsViewerIE {
    private final long RESOURCES_MODIFIED_DATE = com.groupdocs.viewer.e.a.v();

    public ViewerHandler(ServiceConfiguration config) {
        this(config, null, null);
    }

    public ViewerHandler(ServiceConfiguration config, CacheDataHandler cacheHandler) {
        this(config, null, cacheHandler);
    }

    public ViewerHandler(ServiceConfiguration config, InputDataHandler inputDataHandler) {
        this(config, inputDataHandler, null);
    }

    public ViewerHandler(ServiceConfiguration config, InputDataHandler inputDataHandler, CacheDataHandler cacheHandler) {
        super(config, inputDataHandler, cacheHandler);
        String string = config.getConfig().getEncoding();
        if (string != null && !string.isEmpty() && !string.toLowerCase().equals("null")) {
            Utils.ENCODING = config.getConfig().getEncoding();
        }
    }

    public String getHeader() throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("baseUrl", this.config.getApplicationPath());
        return com.groupdocs.viewer.utils.b.a("header.tpl.html", hashMap);
    }

    public String getViewerScript(String viewerId, String filePath, String locale) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", viewerId);
        hashMap.put("backgroundColor", this.config.getConfig().getBackgroundColor());
        hashMap.put("convertWordDocumentsCompletely", this.config.getConfig().isConvertWordDocumentsCompletely());
        hashMap.put("currentSearchHighlightColor", this.config.getConfig().getCurrentSearchHighlightColor());
        hashMap.put("downloadPdfFile", this.config.getConfig().isDownloadPdfFile());
        hashMap.put("enableStandardErrorHandling", this.config.getConfig().isEnableStandardErrorHandling());
        hashMap.put("fileDisplayName", this.config.getConfig().getFileDisplayName());
        hashMap.put("filePath", filePath != null ? filePath : "");
        hashMap.put("height", this.config.getConfig().getHeight());
        hashMap.put("ignoreDocumentAbsence", this.config.getConfig().isIgnoreDocumentAbsence());
        hashMap.put("initialZoom", this.config.getConfig().getInitialZoom());
        hashMap.put("jqueryFileDownloadCookieName", this.config.getConfig().getJqueryFileDownloadCookieName());
        hashMap.put("loadAllPagesOnSearch", this.config.getConfig().isLoadAllPagesOnSearch());
        hashMap.put("locale", locale);
        hashMap.put("minimumImageWidth", this.config.getConfig().getMinimumImageWidth());
        hashMap.put("onlyShrinkLargePages", this.config.getConfig().isOnlyShrinkLargePages());
        hashMap.put("openThumbnails", this.config.getConfig().isOpenThumbnails());
        hashMap.put("preloadPagesCount", this.config.getConfig().getPreloadPagesCount());
        hashMap.put("preloadPagesOnBrowserSide", this.config.getConfig().isPreloadPagesOnBrowserSide());
        hashMap.put("preventTouchEventsBubbling", this.config.getConfig().isPreventTouchEventsBubbling());
        hashMap.put("printWithWatermark", this.config.getConfig().isPrintWithWatermark());
        hashMap.put("quality", this.config.getConfig().getQuality());
        hashMap.put("searchForSeparateWords", this.config.getConfig().isSearchForSeparateWords());
        hashMap.put("searchHighlightColor", this.config.getConfig().getSearchHighlightColor());
        hashMap.put("showDownload", this.config.getConfig().isShowDownload());
        hashMap.put("showDownloadErrorsInPopup", this.config.getConfig().isShowDownloadErrorsInPopup());
        hashMap.put("showFolderBrowser", this.config.getConfig().isShowFolderBrowser());
        hashMap.put("showHeader", this.config.getConfig().isShowHeader());
        hashMap.put("showImageWidth", this.config.getConfig().isShowImageWidth());
        hashMap.put("showOnePageInRow", this.config.getConfig().isShowOnePageInRow());
        hashMap.put("showPaging", this.config.getConfig().isShowPaging());
        hashMap.put("showPrint", this.config.getConfig().isShowPrint());
        hashMap.put("showSearch", this.config.getConfig().isShowSearch());
        hashMap.put("showThumbnails", this.config.getConfig().isShowThumbnails());
        hashMap.put("showViewerStyleControl", this.config.getConfig().isShowViewerStyleControl());
        hashMap.put("showZoom", this.config.getConfig().isShowZoom());
        hashMap.put("supportPageReordering", this.config.getConfig().isSupportPageReordering());
        hashMap.put("supportPageRotation", this.config.getConfig().isSupportPageRotation());
        hashMap.put("supportTextSelection", this.config.getConfig().isSupportTextSelection());
        hashMap.put("thumbnailsContainerBackgroundColor", this.config.getConfig().getThumbnailsContainerBackgroundColor());
        hashMap.put("thumbnailsContainerBorderRightColor", this.config.getConfig().getThumbnailsContainerBorderRightColor());
        hashMap.put("thumbnailsContainerWidth", this.config.getConfig().getThumbnailsContainerWidth());
        hashMap.put("toolbarBorderBottomColor", this.config.getConfig().getToolbarBorderBottomColor());
        hashMap.put("toolbarButtonBorderColor", this.config.getConfig().getToolbarButtonBorderColor());
        hashMap.put("toolbarButtonBorderHoverColor", this.config.getConfig().getToolbarButtonBorderHoverColor());
        hashMap.put("toolbarButtonsBoxShadowHoverStyle", this.config.getConfig().getToolbarButtonsBoxShadowHoverStyle());
        hashMap.put("toolbarButtonsBoxShadowStyle", this.config.getConfig().getToolbarButtonsBoxShadowStyle());
        hashMap.put("toolbarInputFieldBorderColor", this.config.getConfig().getToolbarInputFieldBorderColor());
        hashMap.put("treatPhrasesInDoubleQuotesAsExactPhrases", this.config.getConfig().isTreatPhrasesInDoubleQuotesAsExactPhrases());
        hashMap.put("useEmScaling", this.config.getConfig().isUseEmScaling());
        hashMap.put("useHtmlBasedEngine", this.config.getConfig().isUseHtmlBasedEngine());
        hashMap.put("useImageBasedPrinting", this.config.getConfig().isUseImageBasedPrinting());
        hashMap.put("useInnerThumbnails", this.config.getConfig().isUseInnerThumbnails());
        hashMap.put("usePdfPrinting", this.config.getConfig().isUsePdfPrinting());
        hashMap.put("usePngImagesForHtmlBasedEngine", this.config.getConfig().isUsePngImagesForHtmlBasedEngine());
        hashMap.put("viewerStyle", this.config.getConfig().getViewerStyle());
        hashMap.put("watermarkColor", "");
        hashMap.put("watermarkFontSize", 0);
        hashMap.put("watermarkPosition", "");
        hashMap.put("watermarkText", "");
        hashMap.put("width", this.config.getConfig().getWidth());
        hashMap.put("zoomToFitHeight", this.config.getConfig().isZoomToFitHeight());
        hashMap.put("zoomToFitWidth", this.config.getConfig().isZoomToFitWidth());
        return com.groupdocs.viewer.utils.b.a("viewer.tpl.html", hashMap);
    }

    @Override
    public InputStream getJsHandler(String scriptName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isModified(request)) {
            this.setResponseContentType(response, "text/javascript", true);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("assets/js/" + scriptName);
            return inputStream;
        }
        return null;
    }

    @Override
    public InputStream getCssHandler(String cssName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isModified(request)) {
            this.setResponseContentType(response, "text/css", true);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("assets/css/" + cssName);
            return inputStream;
        }
        return null;
    }

    @Override
    public InputStream getImageHandler(String imageName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isModified(request)) {
            this.setResponseContentType(response, "image/jpeg", true);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("assets/images/" + imageName);
            return inputStream;
        }
        return null;
    }

    @Override
    public InputStream getFontHandler(String fontName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isModified(request)) {
            this.setResponseContentType(response, "application/font-woff", true);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("assets/fonts/" + fontName);
            return inputStream;
        }
        return null;
    }

    @Override
    public InputStream getHtmlResourcesHandler(String filePath, String guid, Integer page, String resourceName, HttpServletResponse response) throws Exception {
        Object object;
        if (filePath.contains("|")) {
            object = filePath.split("\\|");
            filePath = object[0];
            guid = object[1];
            page = Integer.valueOf(object[2]);
            resourceName = object[3];
        }
        Object object2 = object = Utils.isNullOrEmpty(resourceName) ? filePath : resourceName;
        if (Utils.isNullOrEmpty((String)object)) {
            return null;
        }
        InputStream inputStream = null;
        File file = new File(filePath);
        if (!file.exists()) {
            if (Utils.isNullOrEmpty(guid)) {
                throw new f("The resource '" + filePath + "' is not found.");
            }
            GroupDocsFileDescription groupDocsFileDescription = this.inputDataHandler.getFileDescription(guid);
            if (Utils.isNullOrEmpty(resourceName)) {
                resourceName = filePath;
            }
            if (this.cacheHandler.htmlResourceExists(groupDocsFileDescription, page, resourceName)) {
                inputStream = this.cacheHandler.getHtmlResourceStream(groupDocsFileDescription, page, resourceName);
            } else if (this.cacheHandler.imageExists(groupDocsFileDescription, 0, 0)) {
                inputStream = this.cacheHandler.getImageStream(groupDocsFileDescription, 0, 0);
            }
        } else {
            inputStream = new FileInputStream(file);
        }
        object = ((String)object).toLowerCase();
        if (((String)object).endsWith(".png")) {
            this.setResponseContentType(response, "image/png");
        } else if (((String)object).endsWith(".jpg") || ((String)object).endsWith(".jpeg")) {
            this.setResponseContentType(response, "image/jpeg");
        } else if (((String)object).endsWith(".eot")) {
            this.setResponseContentType(response, "application/vnd.ms-fontobject");
        } else if (((String)object).endsWith(".woff")) {
            this.setResponseContentType(response, "application/font-woff");
        } else if (((String)object).endsWith(".ttf")) {
            this.setResponseContentType(response, "application/font-ttf");
        } else {
            this.setResponseContentType(response, "image/svg+xml");
        }
        return inputStream;
    }

    @Override
    public InputStream getFileHandler(String guid, boolean getPdf, HttpServletResponse response) throws Exception {
        InputStream inputStream = null;
        if (response != null) {
            String string;
            Cookie cookie = new Cookie("jqueryFileDownloadJSForGD", "true");
            cookie.setPath("/");
            response.addCookie(cookie);
            response.setHeader("Content-Description", "File Transfer");
            response.setHeader("Content-Transfer-Encoding", "binary");
            response.setHeader("Expires", "0");
            response.setHeader("Cache-Control", "must-revalidate");
            response.setHeader("Pragma", "public");
            GroupDocsFileDescription groupDocsFileDescription = this.inputDataHandler.getFileDescription(guid);
            if (getPdf) {
                d d2 = new d(groupDocsFileDescription, this.config);
                string = groupDocsFileDescription.getBaseName() + ".pdf";
                inputStream = d2.a(this.inputDataHandler, -1);
            } else {
                string = groupDocsFileDescription.getName();
                inputStream = this.inputDataHandler.getFile(groupDocsFileDescription.getGuid());
            }
            if (this.config.getConfig().getFileDisplayName() != null && !this.config.getConfig().getFileDisplayName().isEmpty()) {
                string = this.config.getConfig().getFileDisplayName();
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + string + "\"");
            this.setResponseContentType(response, "application/octet-stream");
        }
        return inputStream;
    }

    @Override
    public InputStream getDocumentPageImageHandler(String path, Integer width, Integer quality, Boolean usePdf, Integer pageIndex, Boolean isPrint, HttpServletResponse response) throws Exception {
        this.setBrowserCache(response);
        this.setResponseContentType(response, "image/jpeg");
        ViewDocumentRequest viewDocumentRequest = new ViewDocumentRequest();
        viewDocumentRequest.setGuid(path);
        viewDocumentRequest.setWidth(width);
        viewDocumentRequest.setQuality(quality);
        viewDocumentRequest.setUsePdf(usePdf);
        return this.generateImage(viewDocumentRequest, pageIndex, isPrint);
    }

    @Override
    public String viewDocumentHandler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.setResponseContentType(response, "application/json");
            ViewDocumentRequest viewDocumentRequest = (ViewDocumentRequest)this.getObjectData(this.getBody(request), ViewDocumentRequest.class);
            ViewDocumentResponse viewDocumentResponse = this.viewDocument(viewDocumentRequest);
            return this.objectToJson(viewDocumentResponse);
        }
        catch (com.groupdocs.viewer.d.c c2) {
            return new a(c2).s();
        }
    }

    @Override
    public String viewDocumentHandler(String callback, String data, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.setResponseContentType(response, "application/json");
            ViewDocumentRequest viewDocumentRequest = (ViewDocumentRequest)this.getObjectData(data, ViewDocumentRequest.class);
            ViewDocumentResponse viewDocumentResponse = this.viewDocument(viewDocumentRequest);
            return this.objectToJson(viewDocumentResponse, callback);
        }
        catch (com.groupdocs.viewer.d.c c2) {
            return new a(c2).s();
        }
    }

    @Override
    public String loadFileBrowserTreeDataHandler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.setResponseContentType(response, "application/json");
            FileBrowserTreeDataRequest fileBrowserTreeDataRequest = (FileBrowserTreeDataRequest)this.getObjectData(this.getBody(request), FileBrowserTreeDataRequest.class);
            FileBrowserTreeDataResponse fileBrowserTreeDataResponse = this.loadFileBrowserTreeData(fileBrowserTreeDataRequest);
            return this.objectToJson(fileBrowserTreeDataResponse);
        }
        catch (com.groupdocs.viewer.d.c c2) {
            return new a(c2).s();
        }
    }

    @Override
    public String loadFileBrowserTreeDataHandler(String callback, String data, HttpServletResponse response) throws Exception {
        try {
            this.setResponseContentType(response, "application/json");
            FileBrowserTreeDataRequest fileBrowserTreeDataRequest = (FileBrowserTreeDataRequest)this.getObjectData(data, FileBrowserTreeDataRequest.class);
            FileBrowserTreeDataResponse fileBrowserTreeDataResponse = this.loadFileBrowserTreeData(fileBrowserTreeDataRequest);
            return this.objectToJson(fileBrowserTreeDataResponse, callback);
        }
        catch (com.groupdocs.viewer.d.c c2) {
            return new a(c2).s();
        }
    }

    @Override
    public String getImageUrlsHandler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ImageUrlsRequest imageUrlsRequest = (ImageUrlsRequest)this.getObjectData(this.getBody(request), ImageUrlsRequest.class);
            ImageUrlsResponse imageUrlsResponse = this.getImageUrls(imageUrlsRequest);
            return this.objectToJson(imageUrlsResponse);
        }
        catch (com.groupdocs.viewer.d.c c2) {
            return new a(c2).s();
        }
    }

    @Override
    public String getImageUrlsHandler(String callback, String data, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ImageUrlsRequest imageUrlsRequest = (ImageUrlsRequest)this.getObjectData(data, ImageUrlsRequest.class);
            ImageUrlsResponse imageUrlsResponse = this.getImageUrls(imageUrlsRequest);
            return this.objectToJson(imageUrlsResponse, callback);
        }
        catch (com.groupdocs.viewer.d.c c2) {
            return new a(c2).s();
        }
    }

    @Override
    public List<String> getPrintableHtmlHandler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResponseContentType(response, "application/json");
        PrintableHtmlRequest printableHtmlRequest = (PrintableHtmlRequest)this.getObjectData(this.getBody(request), PrintableHtmlRequest.class);
        return this.getPrintableHtml(printableHtmlRequest);
    }

    @Override
    public List<String> getPrintableHtmlHandler(String callback, String data, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResponseContentType(response, "application/json");
        PrintableHtmlRequest printableHtmlRequest = (PrintableHtmlRequest)this.getObjectData(data, PrintableHtmlRequest.class);
        return this.getPrintableHtml(printableHtmlRequest);
    }

    public List<String> getPrintableHtmlHandler(PrintableHtmlRequest doc, String mediaType, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResponseContentType(response, mediaType);
        return this.getPrintableHtml(doc);
    }

    @Override
    public InputStream getDocumentPageHtmlHandler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setBrowserCache(response);
        this.setResponseContentType(response, "text/html");
        DocumentPageRequest documentPageRequest = (DocumentPageRequest)this.getObjectData(this.getBody(request), DocumentPageRequest.class);
        GroupDocsFileDescription groupDocsFileDescription = this.inputDataHandler.getFileDescription(documentPageRequest.getPath());
        com.groupdocs.viewer.b.b b2 = new com.groupdocs.viewer.b.b(groupDocsFileDescription, this.config, this.inputDataHandler, this.getCacheHandler());
        b2.c().f();
        String string = b2.c().a(documentPageRequest.getPageIndex());
        b2.c().i();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPdfWithPrintDialog(String guid, HttpServletResponse response) throws Exception {
        InputStream inputStream = null;
        try {
            GroupDocsFileDescription groupDocsFileDescription = this.inputDataHandler.getFileDescription(guid);
            d d2 = new d(groupDocsFileDescription, this.config);
            inputStream = d2.a(this.inputDataHandler, -1);
            c c2 = new c();
            inputStream = c2.f(inputStream);
            if (this.config.getConfig().isPrintWithWatermark().booleanValue()) {
                inputStream = c2.a(this.config, inputStream);
            }
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(ViewerHandler.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    @Override
    public String reorderPageHandler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResponseContentType(response, "application/json");
        ReorderPageRequest reorderPageRequest = (ReorderPageRequest)this.getObjectData(this.getBody(request), ReorderPageRequest.class);
        String string = this.config.getTempDir() + reorderPageRequest.getPath();
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) continue;
            String string2 = file2.getPath() + "/temp." + "png";
            String string3 = file2.getPath() + "/" + reorderPageRequest.getOldPosition() + "." + "png";
            String string4 = file2.getPath() + "/" + reorderPageRequest.getNewPosition() + "." + "png";
            File file3 = new File(string3);
            File file4 = new File(string2);
            file3.renameTo(file4);
            file3 = new File(string4);
            file4 = new File(string3);
            file3.renameTo(file4);
            file3 = new File(string2);
            file4 = new File(string4);
            file3.renameTo(file4);
        }
        ReorderPageResponse reorderPageResponse = new ReorderPageResponse();
        reorderPageResponse.setSucces(true);
        return this.objectToJson(reorderPageResponse);
    }

    @Override
    public String rotatePageHandler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object object;
        this.setResponseContentType(response, "application/json");
        RotatePageRequest rotatePageRequest = (RotatePageRequest)this.getObjectData(this.getBody(request), RotatePageRequest.class);
        String string = rotatePageRequest.getPath();
        int n = rotatePageRequest.getRotationAmount();
        int n2 = rotatePageRequest.getPageNumber();
        if (!this.config.getConfig().isUseHtmlBasedEngine().booleanValue()) {
            object = this.config.getTempDir() + string + "/";
            this.wholeDirImageRotation(new File((String)object), n, n2);
        }
        object = new b();
        ((b)object).setUrl(string);
        ((b)object).b(n2);
        Integer n3 = this.config.getPageRotationManager().b((b)object).q();
        if (n3 == null) {
            if (n < 0) {
                n = 270;
            }
            ((b)object).a(n);
            this.config.getPageRotationManager().a((b)object);
        } else {
            n = n + n3 < 0 ? 270 : (n + n3 > 360 ? 90 : (n += n3.intValue()));
            ((b)object).a(n);
            this.config.getPageRotationManager().c((b)object);
        }
        RotatePageResponse rotatePageResponse = new RotatePageResponse();
        rotatePageResponse.setResultAngle(n);
        rotatePageResponse.setSucces(true);
        return this.objectToJson(rotatePageResponse);
    }

    private void setResponseContentType(HttpServletResponse response, String mediaType) throws Exception {
        this.setResponseContentType(response, mediaType, false);
    }

    private void setResponseContentType(HttpServletResponse response, String mediaType, boolean setDateHeader) throws Exception {
        response.setContentType(mediaType);
        response.setCharacterEncoding("UTF-8");
        if (setDateHeader) {
            response.setDateHeader("Last-Modified", this.RESOURCES_MODIFIED_DATE);
        }
        response.getOutputStream().flush();
    }

    private boolean isModified(HttpServletRequest request) {
        return request.getDateHeader("If-Modified-Since") < this.RESOURCES_MODIFIED_DATE;
    }
}

