/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.viewer.handlers;

import com.groupdocs.viewer.b.c;
import com.groupdocs.viewer.config.ServiceConfiguration;
import com.groupdocs.viewer.d.g;
import com.groupdocs.viewer.domain.DocumentType;
import com.groupdocs.viewer.domain.FileType;
import com.groupdocs.viewer.domain.GroupDocsFileDescription;
import com.groupdocs.viewer.domain.request.FileBrowserTreeDataRequest;
import com.groupdocs.viewer.domain.request.ImageUrlsRequest;
import com.groupdocs.viewer.domain.request.PrintableHtmlRequest;
import com.groupdocs.viewer.domain.request.ViewDocumentRequest;
import com.groupdocs.viewer.domain.response.FileBrowserTreeDataNodeResponse;
import com.groupdocs.viewer.domain.response.FileBrowserTreeDataResponse;
import com.groupdocs.viewer.domain.response.ImageUrlsResponse;
import com.groupdocs.viewer.domain.response.UploadTokenResponse;
import com.groupdocs.viewer.domain.response.ViewDocumentResponse;
import com.groupdocs.viewer.handlers.ViewerHandler;
import com.groupdocs.viewer.handlers.a.a;
import com.groupdocs.viewer.handlers.a.b;
import com.groupdocs.viewer.handlers.a.e;
import com.groupdocs.viewer.handlers.cache.CacheDataHandler;
import com.groupdocs.viewer.handlers.input.InputDataHandler;
import com.groupdocs.viewer.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class ViewerHandlerBasic
extends e {
    public ViewerHandlerBasic(ServiceConfiguration config) {
        this(config, null, null);
    }

    public ViewerHandlerBasic(ServiceConfiguration config, CacheDataHandler cacheHandler) {
        this(config, null, cacheHandler);
    }

    public ViewerHandlerBasic(ServiceConfiguration config, InputDataHandler inputDataHandler) {
        this(config, inputDataHandler, null);
    }

    public ViewerHandlerBasic(ServiceConfiguration config, InputDataHandler inputDataHandler, CacheDataHandler cacheHandler) {
        super(config, inputDataHandler, cacheHandler);
    }

    public ServiceConfiguration getConfiguration() {
        return this.config;
    }

    public InputDataHandler getInputDataHandler() {
        return this.inputDataHandler;
    }

    public CacheDataHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public String getLocale() {
        return new com.groupdocs.viewer.f.a(this.config.getConfig().getLocalesPath()).B();
    }

    public String uploadFile(String filePath, Integer timeToLive) throws Exception {
        return this.uploadFile(new File(filePath), timeToLive);
    }

    public String uploadFile(File file, Integer timeToLive) throws Exception {
        return this.uploadFile(new FileInputStream(file), file.getName(), timeToLive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(InputStream inputStream, String fileName, Integer timeToLive) throws Exception {
        try {
            String string = this.inputDataHandler.saveFile(inputStream, fileName, timeToLive, this.config.getConfig().getEncryptionKey());
            UploadTokenResponse uploadTokenResponse = new UploadTokenResponse(string);
            String string2 = this.objectToJson(uploadTokenResponse);
            return string2;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(ViewerHandler.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    public UploadTokenResponse renewTokenId(String tokenId) {
        String string = b.a(tokenId, this.config.getConfig().getEncryptionKey());
        String[] stringArray = string.split(";");
        String string2 = b.a(stringArray[0], this.config.getConfig().getEncryptionKey(), Integer.parseInt(stringArray[2]) / 1000 / 60);
        UploadTokenResponse uploadTokenResponse = new UploadTokenResponse(string2);
        return uploadTokenResponse;
    }

    public InputStream getDocumentPageImageHandler(String imageUrl) throws Exception {
        HashMap<String, Object> hashMap = Utils.l(imageUrl);
        ViewDocumentRequest viewDocumentRequest = new ViewDocumentRequest();
        viewDocumentRequest.setGuid((String)hashMap.get("path"));
        viewDocumentRequest.setWidth((Integer)hashMap.get("width"));
        viewDocumentRequest.setQuality((Integer)hashMap.get("quality"));
        viewDocumentRequest.setUsePdf((Boolean)hashMap.get("usePdf"));
        InputStream inputStream = this.generateImage(viewDocumentRequest, (Integer)hashMap.get("pageIndex"), (Boolean)hashMap.get("isPrint"));
        return inputStream;
    }

    public ViewDocumentResponse viewDocument(ViewDocumentRequest documentRequest) throws Exception {
        Object object;
        int n;
        String string;
        Object object2;
        if (!com.groupdocs.viewer.e.a.u() && !this.viewAccessManager.a()) {
            throw new g();
        }
        GroupDocsFileDescription groupDocsFileDescription = this.inputDataHandler.getFileDescription(documentRequest.getGuid());
        if (documentRequest.isUseHtmlBasedEngine() == null) {
            documentRequest.setUseHtmlBasedEngine(Boolean.FALSE);
        }
        String string2 = String.format("%sdocument-viewer/GetFileHandler?path=%s&getPdf=", this.config.getApplicationPath(), groupDocsFileDescription.getGuid());
        List<String> list = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (documentRequest.isUseHtmlBasedEngine().booleanValue()) {
            object2 = new com.groupdocs.viewer.b.b(groupDocsFileDescription, this.config, this.inputDataHandler, this.cacheHandler);
            ((com.groupdocs.viewer.b.b)object2).c().e();
            string = ((com.groupdocs.viewer.b.b)object2).c().f().toJson();
            string3 = ((com.groupdocs.viewer.b.b)object2).c().a(0);
            string4 = ((com.groupdocs.viewer.b.b)object2).c().b(0);
            string5 = "";
            n = ((com.groupdocs.viewer.b.b)object2).c().getPageCount();
            ((com.groupdocs.viewer.b.b)object2).c().i();
        } else {
            if (this.config.getConfig().isUseCache().booleanValue() && !this.cacheHandler.pdfExists(groupDocsFileDescription) && !groupDocsFileDescription.isPdf() && !groupDocsFileDescription.isImage()) {
                object2 = this.getPdfStream(groupDocsFileDescription.getGuid(), -1);
                object = this.cacheHandler.getPdfSaveStream(groupDocsFileDescription);
                IOUtils.copy((InputStream)object2, (OutputStream)object);
                ((InputStream)object2).close();
                ((OutputStream)object).close();
            }
            object2 = this.getPdfStream(groupDocsFileDescription.getGuid(), -1);
            object = new c((InputStream)object2, documentRequest, this.config, groupDocsFileDescription, this.cacheHandler);
            n = ((c)object).d().getPageCount();
            string = this.getPdf2JavaScriptHandler(groupDocsFileDescription.getGuid(), n);
            list = this.getImageUrlList(documentRequest, n, false);
            ((InputStream)object2).close();
            ((c)object).d().close();
        }
        object2 = new ViewDocumentResponse();
        ((ViewDocumentResponse)object2).setDoc_type(DocumentType.getDocumentType(groupDocsFileDescription.getFileType().toString()));
        ((ViewDocumentResponse)object2).setDocumentDescription(string);
        ((ViewDocumentResponse)object2).setFileType(groupDocsFileDescription.getFileType().equals((Object)FileType.XML) ? FileType.DOC.toString() : groupDocsFileDescription.getFileType().toString());
        ((ViewDocumentResponse)object2).setGuid(groupDocsFileDescription.getGuid());
        ((ViewDocumentResponse)object2).setId("");
        ((ViewDocumentResponse)object2).setImage_urls(list);
        ((ViewDocumentResponse)object2).setLic(com.groupdocs.viewer.e.a.u());
        ((ViewDocumentResponse)object2).setName(groupDocsFileDescription.getName());
        ((ViewDocumentResponse)object2).setPageCss(string4);
        ((ViewDocumentResponse)object2).setPageHtml(string3);
        ((ViewDocumentResponse)object2).setPage_count(n);
        ((ViewDocumentResponse)object2).setPdfDownloadUrl(string2 + "true");
        ((ViewDocumentResponse)object2).setPdfPrintUrl(String.format("%sdocument-viewer/GetPdfWithPrintDialog?path=%s", this.config.getApplicationPath(), groupDocsFileDescription.getGuid()));
        ((ViewDocumentResponse)object2).setToken("");
        ((ViewDocumentResponse)object2).setUrl(string2 + this.config.getConfig().isDownloadPdfFile());
        ((ViewDocumentResponse)object2).setUrlForResourcesInHtml(string5);
        object = new com.groupdocs.viewer.c.b.b();
        ((com.groupdocs.viewer.c.b.b)object).setUrl(groupDocsFileDescription.getGuid());
        this.config.getPageRotationManager().d((com.groupdocs.viewer.c.b.b)object);
        return object2;
    }

    public FileBrowserTreeDataResponse loadFileBrowserTreeData(FileBrowserTreeDataRequest treeData) throws Exception {
        a a2 = new a(this.config.getTempDir(), this.config.getConfig().getMaxCacheSize());
        a2.t();
        String string = treeData.getPath() != null ? treeData.getPath() : "";
        ArrayList<FileBrowserTreeDataNodeResponse> arrayList = new ArrayList<FileBrowserTreeDataNodeResponse>();
        int n = 1;
        List<GroupDocsFileDescription> list = this.inputDataHandler.getFileDescriptionList(string);
        for (GroupDocsFileDescription groupDocsFileDescription : list) {
            if (groupDocsFileDescription == null) continue;
            String string2 = "temp/".substring(0, "temp/".length() - 1);
            if (groupDocsFileDescription.getName().equals(string2)) continue;
            FileType fileType = groupDocsFileDescription.getFileType();
            FileBrowserTreeDataNodeResponse fileBrowserTreeDataNodeResponse = new FileBrowserTreeDataNodeResponse();
            fileBrowserTreeDataNodeResponse.setId(n++);
            fileBrowserTreeDataNodeResponse.setGuid(groupDocsFileDescription.getGuid());
            fileBrowserTreeDataNodeResponse.setPath(groupDocsFileDescription.getGuid());
            fileBrowserTreeDataNodeResponse.setName(groupDocsFileDescription.getName());
            fileBrowserTreeDataNodeResponse.setType(fileType == FileType.DIRECTORY ? "folder" : "file");
            fileBrowserTreeDataNodeResponse.setExt(fileType.toString());
            fileBrowserTreeDataNodeResponse.setSize(groupDocsFileDescription.getSize());
            fileBrowserTreeDataNodeResponse.setTime(groupDocsFileDescription.getLastModified());
            fileBrowserTreeDataNodeResponse.setModifyTime(groupDocsFileDescription.getLastModified());
            fileBrowserTreeDataNodeResponse.setVersion(0);
            fileBrowserTreeDataNodeResponse.setFileCount(0);
            fileBrowserTreeDataNodeResponse.setFolderCount(0);
            fileBrowserTreeDataNodeResponse.setIsKnown(false);
            fileBrowserTreeDataNodeResponse.setIsShared(false);
            fileBrowserTreeDataNodeResponse.setDocType(DocumentType.getDocumentType(fileType.toString()));
            fileBrowserTreeDataNodeResponse.setFileType(fileType.toString());
            arrayList.add(fileBrowserTreeDataNodeResponse);
        }
        FileBrowserTreeDataResponse fileBrowserTreeDataResponse = new FileBrowserTreeDataResponse(arrayList);
        return fileBrowserTreeDataResponse;
    }

    public ImageUrlsResponse getImageUrls(ImageUrlsRequest image) throws Exception {
        ViewDocumentRequest viewDocumentRequest = new ViewDocumentRequest();
        viewDocumentRequest.setGuid(image.getGuid());
        viewDocumentRequest.setWidth(this.formatWidth(image.getDimension()));
        viewDocumentRequest.setQuality(image.getQuality() != null ? image.getQuality() : 100);
        viewDocumentRequest.setUsePdf(image.isUsePdf());
        viewDocumentRequest.setWatermarkPosition(image.getWatermarkPosition());
        viewDocumentRequest.setWatermarkFontSize(image.getWatermarkFontSize());
        viewDocumentRequest.setUseHtmlBasedEngine(this.config.getConfig().isUseHtmlBasedEngine());
        List<String> list = this.getImageUrlList(viewDocumentRequest, image.getPageCount(), false);
        return new ImageUrlsResponse(list);
    }

    public List<String> getPrintableHtml(PrintableHtmlRequest doc) throws Exception {
        Integer n = this.config.getConfig().getWidth();
        if (n == null || n == 0) {
            n = 1000;
        }
        GroupDocsFileDescription groupDocsFileDescription = this.inputDataHandler.getFileDescription(doc.getPath());
        ViewDocumentRequest viewDocumentRequest = new ViewDocumentRequest();
        viewDocumentRequest.setGuid(groupDocsFileDescription.getGuid());
        viewDocumentRequest.setWidth(n);
        viewDocumentRequest.setQuality(100);
        viewDocumentRequest.setUsePdf(true);
        viewDocumentRequest.setWatermarkPosition(doc.getWatermarkPosition());
        viewDocumentRequest.setWatermarkFontSize(doc.getWatermarkFontSize());
        viewDocumentRequest.setUseHtmlBasedEngine(doc.isUseHtmlBasedEngine());
        InputStream inputStream = this.getPdfStream(viewDocumentRequest.getGuid(), -1);
        c c2 = new c(inputStream, viewDocumentRequest, this.config, groupDocsFileDescription, this.cacheHandler);
        int n2 = c2.d().getPageCount();
        c2.d().close();
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(ViewerHandler.class.getName()).log(Level.SEVERE, null, iOException);
        }
        List<String> list = this.getImageUrlList(viewDocumentRequest, n2, true);
        return list;
    }
}

