/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.viewer.handlers.a;

import com.aspose.pdf.Document;
import com.aspose.slides.FontsLoader;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.groupdocs.viewer.b.c;
import com.groupdocs.viewer.config.ServiceConfiguration;
import com.groupdocs.viewer.domain.DocumentType;
import com.groupdocs.viewer.domain.GroupDocsFileDescription;
import com.groupdocs.viewer.domain.request.ViewDocumentRequest;
import com.groupdocs.viewer.handlers.ViewerHandler;
import com.groupdocs.viewer.handlers.a.d;
import com.groupdocs.viewer.handlers.b.b;
import com.groupdocs.viewer.handlers.cache.CacheDataHandler;
import com.groupdocs.viewer.handlers.cache.a.a;
import com.groupdocs.viewer.handlers.input.InputDataHandler;
import com.groupdocs.viewer.resources.GroupDocsViewer;
import com.groupdocs.viewer.utils.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;

public abstract class e
extends GroupDocsViewer {
    protected final String STRING_EMPTY = "";
    protected final String STRING_FILE = "file";
    protected final String STRING_FOLDER = "folder";
    protected final String DOCUMENT_PAGE_IMAGE_HANDLER_URL = "%sdocument-viewer/GetDocumentPageImageHandler?path=%s&pageIndex={pageIndex}&width=%s&quality=%s&usePdf=%s&watermarkPosition=%s&watermarkFontSize=%d&useHtmlBasedEngine=%s&rotate=%s&isPrint={isPrint}";
    protected final String FILE_HANDLER_URL = "%sdocument-viewer/GetFileHandler?path=%s&getPdf=";
    protected final String PDF_WITH_PRINT_DIALOG_URL = "%sdocument-viewer/GetPdfWithPrintDialog?path=%s";
    protected final String DEFAULT_CHARSET = "UTF-8";
    protected final Pattern pattern = Pattern.compile("(\\d+)");
    protected final ServiceConfiguration config;
    protected final com.groupdocs.viewer.a.a viewAccessManager;
    protected final InputDataHandler inputDataHandler;
    protected final CacheDataHandler cacheHandler;

    public e(ServiceConfiguration serviceConfiguration, InputDataHandler inputDataHandler, CacheDataHandler cacheDataHandler) {
        this.config = serviceConfiguration;
        this.inputDataHandler = inputDataHandler == null ? new com.groupdocs.viewer.handlers.input.a.a(serviceConfiguration) : inputDataHandler;
        this.cacheHandler = cacheDataHandler == null ? new a(serviceConfiguration) : cacheDataHandler;
        this.viewAccessManager = new com.groupdocs.viewer.a.a();
        final String string = System.getProperty("os.name");
        final String string2 = serviceConfiguration.getConfig().getFontsPath();
        ArrayList<String> arrayList = new ArrayList<String>(4){
            {
                super(n);
                if (string == null || !string.toLowerCase().contains("windows")) {
                    this.add("/usr/share/fonts/");
                    this.add("/usr/local/share/fonts/");
                    this.add("/usr/x11R6/lib/X11/fonts/");
                }
                if (!Utils.isNullOrEmpty(string2) && !"null".equalsIgnoreCase(string2)) {
                    this.add(string2);
                }
            }
        };
        FontsLoader.loadExternalFonts((String[])arrayList.toArray(new String[arrayList.size()]));
        Document.getLocalFontPaths().addAll(arrayList);
        com.groupdocs.viewer.e.a.setLicense(serviceConfiguration.getConfig().getLicensePath());
        this.initDirectoryCheck();
        this.config.initLinkManager();
        this.config.initPageRotationManager();
        com.groupdocs.viewer.utils.b.a(this.config.getLinkManager());
        this.preLoadFiles();
    }

    private String getImageUrl(ViewDocumentRequest viewDocument) throws Exception {
        String string = viewDocument.getGuid();
        String string2 = String.format("%sdocument-viewer/GetDocumentPageImageHandler?path=%s&pageIndex={pageIndex}&width=%s&quality=%s&usePdf=%s&watermarkPosition=%s&watermarkFontSize=%d&useHtmlBasedEngine=%s&rotate=%s&isPrint={isPrint}", this.config.getApplicationPath(), string, viewDocument.getWidth(), viewDocument.getQuality(), viewDocument.isUsePdf(), viewDocument.getWatermarkPosition(), viewDocument.getWatermarkFontSize(), viewDocument.isUseHtmlBasedEngine(), this.config.getConfig().isSupportPageRotation());
        return string2;
    }

    protected List<String> getImageUrlList(ViewDocumentRequest viewDocument, int pages, boolean isPrint) throws Exception {
        String string = this.getImageUrl(viewDocument);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < pages; ++i2) {
            arrayList.add(string.replace("{pageIndex}", Integer.toString(i2)).replace("{isPrint}", String.valueOf(isPrint)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream generateImage(ViewDocumentRequest viewDocument, int page, boolean isPrint) throws Exception {
        GroupDocsFileDescription groupDocsFileDescription = this.inputDataHandler.getFileDescription(viewDocument.getGuid());
        if (this.config.getConfig().isUseCache().booleanValue() && this.cacheHandler.imageExists(groupDocsFileDescription, page, viewDocument.getWidth())) {
            InputStream inputStream = this.cacheHandler.getImageStream(groupDocsFileDescription, page, viewDocument.getWidth());
            return inputStream;
        }
        InputStream inputStream = this.getPdfStream(viewDocument.getGuid(), page);
        c c2 = new c(inputStream, viewDocument, this.config, groupDocsFileDescription, isPrint, this.cacheHandler);
        Utils.closeStreams(inputStream);
        if (c2.d() != null) {
            ByteArrayInputStream byteArrayInputStream;
            if (this.config.getConfig().isUseCache().booleanValue()) {
                InputStream inputStream2 = c2.d().d(page);
                c2.d().close();
                return inputStream2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                c2.d().a(page, (OutputStream)byteArrayOutputStream);
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable) {
                Utils.closeStreams(byteArrayOutputStream);
                throw throwable;
            }
            Utils.closeStreams(byteArrayOutputStream);
            return byteArrayInputStream;
        }
        return null;
    }

    protected int formatWidth(String width) {
        Matcher matcher = this.pattern.matcher(width);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return Integer.parseInt(width);
    }

    protected String objectToJson(Object object) throws JsonProcessingException {
        ObjectWriter objectWriter = new ObjectMapper().writer().withDefaultPrettyPrinter();
        String string = objectWriter.writeValueAsString(object);
        return string;
    }

    protected String objectToJson(Object object, String callback) throws JsonProcessingException {
        return callback + "(" + this.objectToJson(object) + ")";
    }

    protected Object getObjectData(String request, Class cls) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Object object = objectMapper.readValue(request, cls);
        return object;
    }

    protected final void initDirectoryCheck() {
        File file = new File(this.config.getTempDir());
        file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBody(HttpServletRequest request) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        ServletInputStream servletInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            servletInputStream = request.getInputStream();
            if (servletInputStream != null) {
                int n;
                inputStreamReader = new InputStreamReader((InputStream)servletInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                char[] cArray = new char[128];
                while ((n = bufferedReader.read(cArray)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            } else {
                stringBuilder.append("");
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (servletInputStream != null) {
                    servletInputStream.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(e.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        String string = stringBuilder.toString();
        return string;
    }

    protected void setBrowserCache(HttpServletResponse response) {
        if (!this.config.getConfig().isUseBrowserCache().booleanValue()) {
            response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.addHeader("Cache-Control", "post-check=0, pre-check=0");
            response.setHeader("Pragma", "no-cache");
        }
    }

    protected final void preLoadFiles() {
        try {
            Logger.getLogger(ViewerHandler.class.getName()).log(Level.INFO, "Indexing files. Please wait...");
            this.inputDataHandler.getFileDescriptionList("");
        }
        catch (Exception exception) {
            Logger.getLogger(ViewerHandler.class.getName()).log(Level.SEVERE, "Unable to load files!");
            Logger.getLogger(ViewerHandler.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    protected InputStream getPdfStream(String guid, int page) throws Exception {
        GroupDocsFileDescription groupDocsFileDescription = this.inputDataHandler.getFileDescription(guid);
        InputStream inputStream = groupDocsFileDescription.isPdf() || groupDocsFileDescription.isImage() ? this.inputDataHandler.getFile(groupDocsFileDescription.getGuid()) : (this.cacheHandler.pdfExists(groupDocsFileDescription) ? this.cacheHandler.getPdfStream(groupDocsFileDescription) : new com.groupdocs.viewer.b.d(groupDocsFileDescription, this.config).a(this.inputDataHandler, page));
        return inputStream;
    }

    protected void wholeDirImageRotation(File dir, int angle, int page) {
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                if (!file.getName().endsWith(page + ".png")) continue;
                b b2 = new b();
                b2.a(file.getPath(), angle);
                continue;
            }
            if (file.getName().equalsIgnoreCase("html")) continue;
            this.wholeDirImageRotation(file, angle, page);
        }
    }

    public String getPdf2JavaScriptHandler(String guid, int pageCount) throws Exception {
        GroupDocsFileDescription groupDocsFileDescription = this.inputDataHandler.getFileDescription(guid);
        String string = FilenameUtils.getExtension((String)groupDocsFileDescription.getName());
        if (!this.config.getConfig().isSupportTextSelection().booleanValue() || DocumentType.getDocumentType(string).equals("Image")) {
            com.groupdocs.viewer.b.b b2 = new com.groupdocs.viewer.b.b(groupDocsFileDescription, this.config, this.inputDataHandler, this.cacheHandler);
            String string2 = b2.c().f().toJson();
            b2.c().i();
            return string2;
        }
        if (this.config.getConfig().isUseCache().booleanValue() && this.cacheHandler.jsExists(groupDocsFileDescription)) {
            return this.cacheHandler.getJsContent(groupDocsFileDescription);
        }
        InputStream inputStream = this.getPdfStream(groupDocsFileDescription.getGuid(), -1);
        d d2 = new d(groupDocsFileDescription);
        String string3 = d2.a(groupDocsFileDescription.getGuid(), inputStream, pageCount);
        inputStream.close();
        if (this.config.getConfig().isUseCache().booleanValue()) {
            this.cacheHandler.saveJsContent(string3, groupDocsFileDescription);
        }
        return string3;
    }
}

