/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.viewer.handlers.input;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.groupdocs.viewer.domain.GroupDocsFileDescription;
import com.groupdocs.viewer.handlers.a.b;
import com.groupdocs.viewer.handlers.input.InputDataHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class AmazonS3InputDataHandler
extends InputDataHandler {
    private final AmazonS3 s3;
    private final String bucketName;
    private final String uploadPath;

    public AmazonS3InputDataHandler(String accessKey, String secretKey, String bucketName) {
        this(accessKey, secretKey, bucketName, null);
    }

    public AmazonS3InputDataHandler(String accessKey, String secretKey, String bucketName, String uploadPath) {
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(accessKey, secretKey);
        this.s3 = new AmazonS3Client((AWSCredentials)basicAWSCredentials);
        this.bucketName = bucketName;
        if (uploadPath == null) {
            this.uploadPath = "";
        } else {
            if (!uploadPath.endsWith("/")) {
                uploadPath = uploadPath + "/";
            }
            this.uploadPath = uploadPath;
        }
    }

    @Override
    public List<GroupDocsFileDescription> getFileDescriptionList(String directory) {
        if (directory != null && !directory.isEmpty()) {
            directory = com.groupdocs.viewer.utils.b.o(directory);
        }
        ObjectListing objectListing = this.s3.listObjects(this.bucketName, directory);
        List list = objectListing.getObjectSummaries();
        ArrayList<GroupDocsFileDescription> arrayList = new ArrayList<GroupDocsFileDescription>();
        String string = "";
        for (S3ObjectSummary s3ObjectSummary : list) {
            GroupDocsFileDescription groupDocsFileDescription = null;
            if (s3ObjectSummary.getKey().contains("/")) {
                String[] stringArray = s3ObjectSummary.getKey().split("/");
                if (s3ObjectSummary.getKey().endsWith("/")) {
                    if (!s3ObjectSummary.getKey().equalsIgnoreCase(directory) && !stringArray[0].equalsIgnoreCase(string)) {
                        string = stringArray[0];
                        groupDocsFileDescription = new GroupDocsFileDescription();
                        groupDocsFileDescription.setGuid(com.groupdocs.viewer.utils.b.p(s3ObjectSummary.getKey()));
                        groupDocsFileDescription.setName(stringArray[stringArray.length - 1]);
                    }
                } else if (!stringArray[0].equalsIgnoreCase(string)) {
                    groupDocsFileDescription = new GroupDocsFileDescription();
                    groupDocsFileDescription.setGuid(com.groupdocs.viewer.utils.b.p(s3ObjectSummary.getKey()));
                    groupDocsFileDescription.setName(stringArray[stringArray.length - 1]);
                    groupDocsFileDescription.setSize(s3ObjectSummary.getSize());
                    groupDocsFileDescription.setLastModified(s3ObjectSummary.getLastModified().getTime());
                }
            } else {
                groupDocsFileDescription = new GroupDocsFileDescription();
                groupDocsFileDescription.setGuid(com.groupdocs.viewer.utils.b.p(s3ObjectSummary.getKey()));
                groupDocsFileDescription.setName(s3ObjectSummary.getKey());
                groupDocsFileDescription.setSize(s3ObjectSummary.getSize());
                groupDocsFileDescription.setLastModified(s3ObjectSummary.getLastModified().getTime());
            }
            if (groupDocsFileDescription == null) continue;
            arrayList.add(groupDocsFileDescription);
        }
        return arrayList;
    }

    @Override
    public GroupDocsFileDescription getFileDescription(String guid) throws Exception {
        String string = com.groupdocs.viewer.utils.b.o(guid);
        S3Object s3Object = this.s3.getObject(new GetObjectRequest(this.bucketName, string));
        GroupDocsFileDescription groupDocsFileDescription = new GroupDocsFileDescription();
        groupDocsFileDescription.setGuid(guid);
        groupDocsFileDescription.setName(s3Object.getKey());
        groupDocsFileDescription.setSize(s3Object.getObjectMetadata().getContentLength());
        groupDocsFileDescription.setLastModified(s3Object.getObjectMetadata().getLastModified().getTime());
        return groupDocsFileDescription;
    }

    @Override
    public InputStream getFile(String guid) {
        String string = com.groupdocs.viewer.utils.b.o(guid);
        S3Object s3Object = this.s3.getObject(new GetObjectRequest(this.bucketName, string));
        return s3Object.getObjectContent();
    }

    @Override
    public String saveFile(InputStream inputStream, String fileName, Integer timeToLive, String encryptedKey) {
        try {
            File file = File.createTempFile("temp", "tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            this.s3.putObject(new PutObjectRequest(this.bucketName, this.uploadPath + fileName, file));
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            int n = 0;
            if (timeToLive != null) {
                n = timeToLive;
            }
            String string = b.a(this.uploadPath + fileName, encryptedKey, n);
            return string;
        }
        catch (IOException iOException) {
            Logger.getLogger(AmazonS3InputDataHandler.class.getName()).log(Level.SEVERE, null, iOException);
            return null;
        }
    }
}

