/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.viewer.handlers.input;

import com.groupdocs.viewer.domain.GroupDocsFileDescription;
import com.groupdocs.viewer.handlers.a.b;
import com.groupdocs.viewer.handlers.input.InputDataHandler;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class AzureInputDataHandler
extends InputDataHandler {
    private final String CONNECTION = "DefaultEndpointsProtocol=http;AccountName=%s;AccountKey=%s";
    private final String accountName;
    private final String accoutnKey;

    public AzureInputDataHandler(String accountName, String accoutnKey) {
        this.accountName = accountName;
        this.accoutnKey = accoutnKey;
    }

    @Override
    public List<GroupDocsFileDescription> getFileDescriptionList(String directory) {
        CloudBlobContainer cloudBlobContainer = this.createContainer();
        Iterable iterable = cloudBlobContainer.listBlobs();
        ArrayList<GroupDocsFileDescription> arrayList = new ArrayList<GroupDocsFileDescription>();
        for (ListBlobItem listBlobItem : iterable) {
            GroupDocsFileDescription groupDocsFileDescription = new GroupDocsFileDescription();
            File file = new File(listBlobItem.getUri().getPath());
            groupDocsFileDescription.setGuid(com.groupdocs.viewer.utils.b.o(file.getPath()));
            groupDocsFileDescription.setName(file.getName());
            if (file.isFile()) {
                groupDocsFileDescription.setSize(file.length());
                groupDocsFileDescription.setLastModified(file.lastModified());
            }
            arrayList.add(groupDocsFileDescription);
        }
        return arrayList;
    }

    @Override
    public GroupDocsFileDescription getFileDescription(String guid) throws Exception {
        String string = com.groupdocs.viewer.utils.b.o(guid);
        CloudBlobContainer cloudBlobContainer = this.createContainer();
        for (ListBlobItem listBlobItem : cloudBlobContainer.listBlobs()) {
            CloudBlob cloudBlob;
            if (!(listBlobItem instanceof CloudBlob) || !(cloudBlob = (CloudBlob)listBlobItem).getName().equalsIgnoreCase(string)) continue;
            File file = new File(listBlobItem.getUri().getPath());
            GroupDocsFileDescription groupDocsFileDescription = new GroupDocsFileDescription();
            groupDocsFileDescription.setGuid(com.groupdocs.viewer.utils.b.o(file.getPath()));
            groupDocsFileDescription.setName(file.getName());
            if (file.isFile()) {
                groupDocsFileDescription.setSize(file.length());
                groupDocsFileDescription.setLastModified(file.lastModified());
            }
            return groupDocsFileDescription;
        }
        return null;
    }

    @Override
    public InputStream getFile(String guid) throws URISyntaxException, StorageException {
        String string = com.groupdocs.viewer.utils.b.o(guid);
        CloudBlobContainer cloudBlobContainer = this.createContainer();
        for (ListBlobItem listBlobItem : cloudBlobContainer.listBlobs()) {
            CloudBlob cloudBlob;
            if (!(listBlobItem instanceof CloudBlob) || !(cloudBlob = (CloudBlob)listBlobItem).getName().equalsIgnoreCase(string)) continue;
            return cloudBlob.openInputStream();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveFile(InputStream inputStream, String fileName, Integer timeToLive, String encryptedKey) {
        FileOutputStream fileOutputStream = null;
        try {
            int n = 0;
            if (timeToLive != null) {
                n = timeToLive;
            }
            String string = b.a(fileName, encryptedKey, n);
            File file = File.createTempFile(fileName, ".tmp");
            fileOutputStream = new FileOutputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            CloudBlobContainer cloudBlobContainer = this.createContainer();
            CloudBlockBlob cloudBlockBlob = cloudBlobContainer.getBlockBlobReference(fileName);
            cloudBlockBlob.upload(inputStream, file.length());
            String string2 = string;
            return string2;
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger(AzureInputDataHandler.class.getName()).log(Level.SEVERE, null, uRISyntaxException);
            String string = null;
            return string;
        }
        catch (StorageException storageException) {
            Logger.getLogger(AzureInputDataHandler.class.getName()).log(Level.SEVERE, null, storageException);
            String string = null;
            return string;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(AzureInputDataHandler.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
            String string = null;
            return string;
        }
        catch (IOException iOException) {
            Logger.getLogger(AzureInputDataHandler.class.getName()).log(Level.SEVERE, null, iOException);
            String string = null;
            return string;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(AzureInputDataHandler.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    private CloudBlobContainer createContainer() {
        try {
            CloudStorageAccount cloudStorageAccount = CloudStorageAccount.parse((String)String.format("DefaultEndpointsProtocol=http;AccountName=%s;AccountKey=%s", this.accountName, this.accoutnKey));
            CloudBlobClient cloudBlobClient = cloudStorageAccount.createCloudBlobClient();
            CloudBlobContainer cloudBlobContainer = cloudBlobClient.getContainerReference("groupdocs");
            cloudBlobContainer.createIfNotExists();
            return cloudBlobContainer;
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger(AzureInputDataHandler.class.getName()).log(Level.SEVERE, null, uRISyntaxException);
            return null;
        }
        catch (StorageException storageException) {
            Logger.getLogger(AzureInputDataHandler.class.getName()).log(Level.SEVERE, null, storageException);
            return null;
        }
        catch (InvalidKeyException invalidKeyException) {
            Logger.getLogger(AzureInputDataHandler.class.getName()).log(Level.SEVERE, null, invalidKeyException);
            return null;
        }
    }
}

