/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class WeakMessageDigestDetector
extends OpcodeStackDetector {
    private static final String WEAK_MESSAGE_DIGEST_TYPE = "WEAK_MESSAGE_DIGEST";
    private BugReporter bugReporter;

    public WeakMessageDigestDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        String algorithm;
        OpcodeStack.Item top;
        if (seen == 184 && this.getClassConstantOperand().equals("java/security/MessageDigest") && this.getNameConstantOperand().equals("getInstance") && this.getSigConstantOperand().equals("(Ljava/lang/String;)Ljava/security/MessageDigest;")) {
            top = this.stack.getStackItem(0);
            algorithm = (String)top.getConstant();
            this.analyzeHashingFunction(algorithm);
        }
        if (seen == 184 && this.getClassConstantOperand().equals("org/apache/commons/codec/digest/DigestUtils")) {
            if (this.getNameConstantOperand().equals("getMd2Digest") || this.getNameConstantOperand().equals("md2Hex")) {
                this.analyzeHashingFunction("md2");
            }
            if (this.getNameConstantOperand().equals("getMd5Digest") || this.getNameConstantOperand().equals("md5Hex")) {
                this.analyzeHashingFunction("md5");
            }
            if (this.getNameConstantOperand().equals("getSha1Digest") || this.getNameConstantOperand().equals("getShaDigest") || this.getNameConstantOperand().equals("sha1Hex")) {
                this.analyzeHashingFunction("sha1");
            }
            if (this.getNameConstantOperand().equals("getDigest")) {
                top = this.stack.getStackItem(0);
                algorithm = (String)top.getConstant();
                this.analyzeHashingFunction(algorithm);
            }
        }
    }

    private void analyzeHashingFunction(String algorithm) {
        if (algorithm == null) {
            return;
        }
        if ("MD2".equals(algorithm = algorithm.toUpperCase()) || "MD5".equals(algorithm)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_MESSAGE_DIGEST_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(algorithm));
        }
        if ("SHA1".equals(algorithm)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_MESSAGE_DIGEST_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(algorithm));
        }
    }
}

