/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.command;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class CommandInjectionSource
implements InjectionSource {
    private static final String COMMAND_INJECTION_TYPE = "COMMAND_INJECTION";

    @Override
    public boolean isCandidate(ConstantPoolGen cpg) {
        for (int i = 0; i < cpg.getSize(); ++i) {
            String utf8String;
            Constant cnt = cpg.getConstant(i);
            if (!(cnt instanceof ConstantUtf8) || !(utf8String = ((ConstantUtf8)cnt).getBytes()).startsWith("java/lang/Runtime")) continue;
            return true;
        }
        return false;
    }

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        if (ins instanceof INVOKEVIRTUAL) {
            String methodName = ins.getMethodName(cpg);
            String className = ins.getClassName(cpg);
            if (className.equals("java.lang.Runtime") && methodName.equals("exec")) {
                InjectionPoint ip = new InjectionPoint(new int[]{0}, COMMAND_INJECTION_TYPE);
                ip.setInjectableMethod("Runtime.exec(...)");
                return ip;
            }
            if (className.equals("java.lang.ProcessBuilder") && methodName.equals("command")) {
                InjectionPoint ip = new InjectionPoint(new int[]{0}, COMMAND_INJECTION_TYPE);
                ip.setInjectableMethod("ProcessBuilder.command(...)");
                return ip;
            }
        }
        return InjectionPoint.NONE;
    }
}

