/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.endpoint;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SpringMvcEndpointDetector
implements Detector {
    private static final String SPRING_ENDPOINT_TYPE = "SPRING_ENDPOINT";
    private BugReporter bugReporter;

    public SpringMvcEndpointDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : javaClass.getMethods()) {
            for (AnnotationEntry ae : m.getAnnotationEntries()) {
                if (!ae.getAnnotationType().equals("Lorg/springframework/web/bind/annotation/RequestMapping;")) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, SPRING_ENDPOINT_TYPE, 3).addClassAndMethod(javaClass, m));
            }
        }
    }

    public void report() {
    }
}

