/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintDataflow;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public abstract class TaintDetector
implements Detector {
    private final BugReporter bugReporter;

    protected TaintDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        ArrayList<InjectionSource> selectedSources = new ArrayList<InjectionSource>();
        for (InjectionSource source : this.getInjectionSource()) {
            if (!source.isCandidate(cpg)) continue;
            selectedSources.add(source);
        }
        if (selectedSources.isEmpty()) {
            return;
        }
        JavaClass javaClass = classContext.getJavaClass();
        for (Method method : methodList = javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null) continue;
            try {
                this.analyzeMethod(classContext, method, selectedSources);
            }
            catch (CheckedAnalysisException e) {
                this.logException(classContext, method, (Exception)((Object)e));
            }
            catch (RuntimeException e) {
                this.logException(classContext, method, e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method, List<InjectionSource> selectedSources) throws DataflowAnalysisException, CFGBuilderException, CheckedAnalysisException {
        JavaClass javaClass = classContext.getJavaClass();
        TaintDataflow dataflow = this.getTaintDataFlow(javaClass, method);
        CFG cfg = classContext.getCFG(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            TaintFrame fact;
            InjectionSource source;
            Location location = (Location)i.next();
            InstructionHandle handle = location.getHandle();
            Instruction instruction = handle.getInstruction();
            if (!(instruction instanceof InvokeInstruction)) continue;
            InvokeInstruction invoke = (InvokeInstruction)instruction;
            InjectionPoint injectionPoint = null;
            Iterator<InjectionSource> i$ = selectedSources.iterator();
            while (i$.hasNext() && (injectionPoint = (source = i$.next()).getInjectableParameters(invoke, cpg, handle)) == InjectionPoint.NONE) {
            }
            if (injectionPoint == null || injectionPoint == InjectionPoint.NONE || !(fact = (TaintFrame)((Object)dataflow.getFactAtLocation(location))).isValid()) continue;
            for (int offset : injectionPoint.getInjectableArguments()) {
                Taint parameterTaint = (Taint)fact.getStackValue(offset);
                this.reportBug(injectionPoint, classContext, method, location, parameterTaint);
            }
        }
    }

    private void reportBug(InjectionPoint injectionPoint, ClassContext classContext, Method method, Location location, Taint taint) {
        BugInstance bugInstance = this.getBugInstance(injectionPoint, taint);
        JavaClass javaClass = classContext.getJavaClass();
        bugInstance.addClass(javaClass).addMethod(javaClass, method);
        bugInstance.addSourceLine(classContext, method, location);
        if (injectionPoint.getInjectableMethod() != null) {
            bugInstance.addString(injectionPoint.getInjectableMethod());
        }
        if (taint.hasTaintedLocations()) {
            this.addSourceLines(classContext, method, taint.getTaintedLocations(), bugInstance);
        } else {
            this.addSourceLines(classContext, method, taint.getPossibleTaintedLocations(), bugInstance);
        }
        this.bugReporter.reportBug(bugInstance);
    }

    private BugInstance getBugInstance(InjectionPoint injectionPoint, Taint taint) {
        int priority = taint.isTainted() ? 1 : (!taint.isSafe() ? 2 : 3);
        return new BugInstance((Detector)this, injectionPoint.getBugType(), priority);
    }

    private void addSourceLines(ClassContext classContext, Method method, Collection<Location> locations, BugInstance bugInstance) {
        for (Location location : locations) {
            SourceLineAnnotation taintSource = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (Method)method, (Location)location);
            bugInstance.addSourceLine(taintSource);
        }
    }

    private TaintDataflow getTaintDataFlow(JavaClass javaClass, Method method) throws CheckedAnalysisException {
        MethodDescriptor descriptor = BCELUtil.getMethodDescriptor((JavaClass)javaClass, (Method)method);
        return (TaintDataflow)((Object)Global.getAnalysisCache().getMethodAnalysis(TaintDataflow.class, descriptor));
    }

    private void logException(ClassContext classContext, Method method, Exception ex) {
        this.bugReporter.logError("Exception while analyzing " + classContext.getFullyQualifiedMethodName(method), (Throwable)ex);
    }

    public void report() {
    }

    public abstract InjectionSource[] getInjectionSource();
}

