/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameModelingVisitor;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummaryMap;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class TaintAnalysis
extends FrameDataflowAnalysis<Taint, TaintFrame> {
    private final MethodGen methodGen;
    private final TaintFrameModelingVisitor visitor;

    public TaintAnalysis(MethodGen methodGen, DepthFirstSearch dfs, TaintMethodSummaryMap methodSummaries) {
        super(dfs);
        this.methodGen = methodGen;
        this.visitor = new TaintFrameModelingVisitor(methodGen.getConstantPool(), methodSummaries);
    }

    protected void mergeValues(TaintFrame frame, TaintFrame result, int i) throws DataflowAnalysisException {
        result.setValue(i, Taint.merge((Taint)result.getValue(i), (Taint)frame.getValue(i)));
    }

    public void transferInstruction(InstructionHandle handle, BasicBlock block, TaintFrame fact) throws DataflowAnalysisException {
        this.visitor.setFrameAndLocation(fact, new Location(handle, block));
        this.visitor.analyzeInstruction(handle.getInstruction());
    }

    public TaintFrame createFact() {
        return new TaintFrame(this.methodGen.getMaxLocals());
    }

    public void initEntryFact(TaintFrame fact) throws DataflowAnalysisException {
        fact.setValid();
        fact.clearStack();
        int numSlots = fact.getNumSlots();
        for (int i = 0; i < numSlots; ++i) {
            fact.setValue(i, new Taint(Taint.State.UNKNOWN));
        }
    }

    public void meetInto(TaintFrame fact, Edge edge, TaintFrame result) throws DataflowAnalysisException {
        if (fact.isValid() && edge.isExceptionEdge()) {
            TaintFrame copy = null;
            copy = (TaintFrame)this.modifyFrame(fact, copy);
            copy.clearStack();
            copy.pushValue(new Taint(Taint.State.UNKNOWN));
            fact = copy;
        }
        this.mergeInto(fact, result);
    }
}

