/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.TaintAnalysis;
import com.h3xstream.findsecbugs.taintanalysis.TaintDataflow;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummaryMap;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.generic.MethodGen;

public class TaintDataflowEngine
implements IMethodAnalysisEngine<TaintDataflow> {
    private static final String METHODS_SUMMARIES_PATH = "taint-config/methods-summaries.txt";
    private final TaintMethodSummaryMap methodSummaries = new TaintMethodSummaryMap();

    public TaintDataflowEngine() {
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(METHODS_SUMMARIES_PATH);
            this.methodSummaries.load(stream);
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot load resources", ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException("cannot close stream", ex);
                }
            }
        }
    }

    public TaintDataflow analyze(IAnalysisCache cache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        CFG cfg = (CFG)cache.getMethodAnalysis(CFG.class, descriptor);
        DepthFirstSearch dfs = (DepthFirstSearch)cache.getMethodAnalysis(DepthFirstSearch.class, descriptor);
        MethodGen methodGen = (MethodGen)cache.getMethodAnalysis(MethodGen.class, descriptor);
        TaintAnalysis analysis = new TaintAnalysis(methodGen, dfs, this.methodSummaries);
        TaintDataflow flow = new TaintDataflow(cfg, analysis);
        flow.execute();
        return flow;
    }

    public void registerWith(IAnalysisCache iac) {
        iac.registerMethodAnalysisEngine(TaintDataflow.class, (IMethodAnalysisEngine)this);
    }

    public boolean canRecompute() {
        return true;
    }
}

